/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.popupfield;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openbp.common.listener.AWTListenerSupport;
import org.openbp.swing.components.popupfield.PopupEvent;
import org.openbp.swing.components.popupfield.PopupListener;
import org.openbp.swing.plaf.sky.SimpleBorder;
import org.openbp.swing.plaf.sky.SkyTheme;

public abstract class JPopupField
extends JPanel {
    protected JLabel label;
    protected JButton arrowButton;
    protected JTextField textField;
    private AWTListenerSupport listenerSupport;

    public JPopupField() {
        super(new BorderLayout());
        this.setOpaque(true);
        this.setFocusable(false);
        this.textField = this.createTextField();
        this.arrowButton = this.createArrowButton();
        this.textField.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 0, 2), this.textField.getBorder()));
        this.add((Component)this.textField, "Center");
        this.add((Component)this.arrowButton, "East");
        this.installAncestorListener();
    }

    protected JTextField createTextField() {
        JTextField tf = new JTextField();
        PopupFieldKeyListener keyListener = new PopupFieldKeyListener();
        this.addKeyListener(keyListener);
        tf.addKeyListener(keyListener);
        tf.addFocusListener(new PopupFieldFocusListener());
        return tf;
    }

    protected JButton createArrowButton() {
        int h;
        BasicArrowButton btn = new BasicArrowButton(5);
        btn.setBorder(new SimpleBorder(0, 2, 0, 2));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JPopupField.this.isEnabled()) {
                    JPopupField.this.showPopup();
                }
            }
        });
        btn.setEnabled(true);
        btn.setFocusable(false);
        btn.setRequestFocusEnabled(false);
        Dimension size = new Dimension(((JComponent)btn).getMinimumSize());
        size.height = h = this.textField.getHeight();
        btn.setMinimumSize(size);
        btn.setMaximumSize(size);
        btn.setPreferredSize(size);
        return btn;
    }

    protected void installAncestorListener() {
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                JPopupField.this.hidePopup();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                JPopupField.this.hidePopup();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                if (event.getSource() != JPopupField.this) {
                    JPopupField.this.hidePopup();
                }
            }
        });
    }

    public void setHighlight() {
        if (!this.isEditable()) {
            this.textField.setBackground(SkyTheme.COLOR_HIGHLIGHT);
        } else {
            this.textField.setSelectionStart(0);
            int length = this.textField.getText().length();
            this.textField.setSelectionEnd(length);
        }
    }

    public void resetHighlight() {
        if (!this.isEditable()) {
            this.textField.setBackground(UIManager.getColor("TextField.background"));
        } else {
            this.textField.setCaretPosition(0);
            this.textField.setSelectionStart(0);
            this.textField.setSelectionEnd(0);
        }
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    @Override
    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        this.arrowButton.setEnabled(enabled);
    }

    protected boolean selectWithKeyChar(char selectionChar) {
        return false;
    }

    public void showPopup() {
        this.setPopupVisible(true);
    }

    public void hidePopup() {
        this.setPopupVisible(false);
    }

    public abstract boolean isPopupVisible();

    public abstract void setPopupVisible(boolean var1);

    public String getText() {
        String text = this.textField.getText();
        return text.length() != 0 ? text : null;
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public String getLabelText() {
        return this.label != null ? this.label.getText() : null;
    }

    public void setLabelText(String labelText) {
        if (this.label != null) {
            this.remove(this.label);
            this.label = null;
        }
        if (labelText != null) {
            this.label = new JLabel(labelText);
            this.label.setBorder(new EmptyBorder(0, 0, 0, 5));
            this.add((Component)this.label, "West");
        }
    }

    public boolean isEditable() {
        return this.textField.isEditable();
    }

    public void setEditable(boolean editable) {
        this.textField.setEditable(editable);
    }

    public void fireActionPerformed() {
        if (this.listenerSupport != null && this.listenerSupport.containsListeners(ActionListener.class)) {
            this.listenerSupport.fireActionPerformed(new ActionEvent(this, 0, "selected"));
        }
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.listenerSupport == null) {
            this.listenerSupport = new AWTListenerSupport();
        }
        this.listenerSupport.addListener(ActionListener.class, (EventListener)listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        if (this.listenerSupport != null) {
            this.listenerSupport.removeListener(ActionListener.class, (EventListener)listener);
        }
    }

    public void firePopup(int cause) {
        if (this.listenerSupport != null) {
            PopupEvent e = null;
            Iterator it = this.listenerSupport.getListenerIterator(PopupListener.class);
            while (it.hasNext()) {
                if (e == null) {
                    e = new PopupEvent(this, cause);
                }
                ((PopupListener)it.next()).popupStateChanged(e);
            }
        }
    }

    public synchronized void addPopupListener(PopupListener listener) {
        if (this.listenerSupport == null) {
            this.listenerSupport = new AWTListenerSupport();
        }
        this.listenerSupport.addListener(PopupListener.class, (EventListener)listener);
    }

    public synchronized void removePopupListener(PopupListener listener) {
        if (this.listenerSupport != null) {
            this.listenerSupport.removeListener(PopupListener.class, (EventListener)listener);
        }
    }

    private class PopupFieldFocusListener
    implements FocusListener {
        private PopupFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            JPopupField.this.setHighlight();
        }

        @Override
        public void focusLost(FocusEvent e) {
            JPopupField.this.resetHighlight();
        }
    }

    private class PopupFieldKeyListener
    extends KeyAdapter {
        private PopupFieldKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 32: {
                    if (JPopupField.this.isEditable() || JPopupField.this.isPopupVisible()) break;
                    e.consume();
                    JPopupField.this.showPopup();
                    return;
                }
                case 10: 
                case 40: {
                    if (JPopupField.this.isPopupVisible()) break;
                    if (e.isControlDown() || e.isAltDown() || e.isAltGraphDown()) {
                        e.consume();
                        JPopupField.this.showPopup();
                        return;
                    }
                    if (keyCode != 10) break;
                    JPopupField.this.fireActionPerformed();
                    break;
                }
                case 9: {
                    JPopupField.this.hidePopup();
                    break;
                }
                default: {
                    char c;
                    if (JPopupField.this.isEditable() || !JPopupField.this.selectWithKeyChar(c = e.getKeyChar())) break;
                    e.consume();
                    return;
                }
            }
        }
    }
}

