/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.popupfield;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextField;
import org.openbp.common.CommonUtil;
import org.openbp.common.util.iterator.EmptyIterator;
import org.openbp.swing.components.popupfield.JPopupField;
import org.openbp.swing.components.popupfield.JSelectionPopup;

public class JSelectionField
extends JPopupField {
    private List itemList;
    private int maximumRowCount = 10;
    protected JSelectionPopup popup;

    public JSelectionField() {
        this.add((Component)this.textField, "Center");
    }

    @Override
    protected JTextField createTextField() {
        JTextField tf = super.createTextField();
        tf.addMouseListener(new SelectionMouseListener());
        return tf;
    }

    public void adjustPreferredSize() {
        int n = this.getNumberOfItems();
        if (n > 0) {
            Dimension size = this.textField.getMinimumSize();
            int max = size.width;
            Font font = this.getFont();
            FontMetrics fm = this.getFontMetrics(font);
            for (int i = 0; i < n; ++i) {
                int w;
                String s;
                Object o = this.itemList.get(i);
                String string = s = o != null ? o.toString() : null;
                if (s == null || (w = fm.stringWidth(s)) <= max) continue;
                max = w;
            }
            Dimension prefSize = this.arrowButton.getPreferredSize();
            max += prefSize.width;
            if (this.label != null) {
                prefSize = this.label.getPreferredSize();
                max += prefSize.width;
            }
            size = this.getMaximumSize();
            size.width = max += 8;
            this.setMaximumSize(size);
        }
    }

    @Override
    protected boolean selectWithKeyChar(char selectionChar) {
        char c;
        String s;
        Object o;
        int i;
        int n = this.getNumberOfItems();
        if (n == 0) {
            return false;
        }
        int index = this.getSelectedIndex();
        for (i = index + 1; i < n; ++i) {
            o = this.itemList.get(i);
            String string = s = o != null ? o.toString() : null;
            if (s == null || s.length() <= 0 || (c = Character.toLowerCase(s.charAt(0))) != selectionChar) continue;
            this.setSelectedIndex(i);
            this.fireActionPerformed();
            return true;
        }
        for (i = 0; i < index; ++i) {
            o = this.itemList.get(i);
            String string = s = o != null ? o.toString() : null;
            if (s == null || s.length() <= 0 || (c = Character.toLowerCase(s.charAt(0))) != selectionChar) continue;
            this.setSelectedIndex(i);
            this.fireActionPerformed();
            return true;
        }
        return false;
    }

    @Override
    public boolean isPopupVisible() {
        return this.popup != null && this.popup.isVisible();
    }

    @Override
    public void setPopupVisible(boolean popupVisible) {
        if (popupVisible) {
            if (this.popup == null) {
                this.popup = new JSelectionPopup(this);
            }
            this.popup.showPopup();
        } else if (this.popup != null) {
            this.popup.hidePopup();
        }
    }

    void notifyPopupClosed() {
    }

    public Object getSelectedItem() {
        String text;
        if (this.itemList != null && (text = this.getText()) != null) {
            int n = this.itemList.size();
            for (int i = 0; i < n; ++i) {
                String s;
                Object o = this.itemList.get(i);
                if (o == null || !CommonUtil.equalsNull((Object)(s = o.toString()), (Object)text)) continue;
                if (o instanceof DisplayableObject) {
                    return ((DisplayableObject)o).getItem();
                }
                return o;
            }
        }
        return null;
    }

    public void setSelectedItem(Object selectedItem) {
        if (this.itemList != null) {
            int n = this.itemList.size();
            for (int i = 0; i < n; ++i) {
                DisplayableObject dobj;
                Object o = this.itemList.get(i);
                if (!(o instanceof DisplayableObject) || !CommonUtil.equalsNull((Object)selectedItem, (Object)(dobj = (DisplayableObject)o).getItem())) continue;
                this.setText(dobj.toString());
                return;
            }
        }
        this.setText(selectedItem != null ? selectedItem.toString() : null);
    }

    public int getSelectedIndex() {
        if (this.itemList != null) {
            String text = this.getText();
            int n = this.itemList.size();
            for (int i = 0; i < n; ++i) {
                String s;
                Object o = this.itemList.get(i);
                String string = s = o != null ? o.toString() : null;
                if (!CommonUtil.equalsNull((Object)s, (Object)text)) continue;
                return i;
            }
        }
        return -1;
    }

    public void setSelectedIndex(int selectedIndex) {
        if (selectedIndex < 0 || selectedIndex >= this.getNumberOfItems()) {
            this.setText(null);
            return;
        }
        Object o = this.itemList.get(selectedIndex);
        this.setText(o != null ? o.toString() : null);
    }

    public Iterator getItems() {
        if (this.itemList == null) {
            return EmptyIterator.getInstance();
        }
        return this.itemList.iterator();
    }

    public int getNumberOfItems() {
        return this.itemList != null ? this.itemList.size() : 0;
    }

    public String getItemTextAt(int index) {
        Object o = this.itemList.get(index);
        return o != null ? o.toString() : null;
    }

    public Object getItemAt(int index) {
        return this.itemList.get(index);
    }

    public void addItem(Object item) {
        if (item != null && item.equals("")) {
            item = null;
        }
        if (this.itemList == null) {
            this.itemList = new ArrayList();
        }
        this.itemList.add(item);
    }

    public void addItem(String text, Object item) {
        if (text != null && text.equals("")) {
            text = null;
        }
        if (item != null && item.equals("")) {
            item = null;
        }
        if (this.itemList == null) {
            this.itemList = new ArrayList();
        }
        this.itemList.add(new DisplayableObject(text, item));
    }

    public void clearItems() {
        this.itemList = null;
    }

    public List getItemList() {
        return this.itemList;
    }

    public void setItemList(List itemList) {
        this.itemList = itemList;
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setMaximumRowCount(int maximumRowCount) {
        this.maximumRowCount = maximumRowCount;
    }

    private class SelectionMouseListener
    extends MouseAdapter {
        private SelectionMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!JSelectionField.this.isPopupVisible() && !JSelectionField.this.isEditable() && JSelectionField.this.isEnabled()) {
                JSelectionField.this.showPopup();
            }
        }
    }

    private static class DisplayableObject {
        private Object item;
        private String text;

        public DisplayableObject(String text, Object item) {
            this.text = text;
            this.item = item;
        }

        public String toString() {
            return this.text;
        }

        public Object getItem() {
            return this.item;
        }
    }
}

