/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.popupfield;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataListener;
import javax.swing.event.MouseInputAdapter;
import org.openbp.swing.components.popupfield.JSelectionField;

public class JSelectionPopup
extends JPopupMenu {
    private JSelectionField selectionField;
    private JList list;
    private JScrollPane scroller;

    public JSelectionPopup(JSelectionField selectionField) {
        this.setInvoker(selectionField);
        this.setLightWeightPopupEnabled(true);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.selectionField = selectionField;
        this.createComponent();
        this.add(this.scroller);
    }

    protected void createComponent() {
        this.list = new JList(this.createSelectionFieldListModel());
        this.list.setSelectionMode(0);
        JTextField textField = this.selectionField.getTextField();
        this.list.setFont(textField.getFont());
        this.list.setForeground(UIManager.getColor("TextField.foreground"));
        this.list.setBackground(UIManager.getColor("TextField.background"));
        this.list.setSelectionForeground(UIManager.getColor("ComboBox.selectionForeground"));
        this.list.setSelectionBackground(UIManager.getColor("ComboBox.selectionBackground"));
        ListMouseHandler listMouseHandler = new ListMouseHandler();
        this.list.addMouseListener(listMouseHandler);
        this.list.addMouseMotionListener(listMouseHandler);
        this.list.addKeyListener(new ListKeyHandler());
        this.list.addFocusListener(new ListFocusHandler());
        this.scroller = new JScrollPane(this.list, 20, 31);
        this.scroller.setRequestFocusEnabled(false);
        this.scroller.getVerticalScrollBar().setRequestFocusEnabled(false);
    }

    protected ListModel createSelectionFieldListModel() {
        return new ListModel(){

            @Override
            public int getSize() {
                return JSelectionPopup.this.selectionField.getNumberOfItems();
            }

            public Object getElementAt(int index) {
                String o = JSelectionPopup.this.selectionField.getItemTextAt(index);
                if (o == null) {
                    o = " ";
                }
                return o;
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        };
    }

    public JList getList() {
        return this.list;
    }

    @Override
    public void requestFocus() {
        this.list.requestFocus();
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    public void showPopup() {
        this.selectionField.firePopup(1);
        int x = 0;
        int y = this.selectionField.getHeight();
        int w = this.selectionField.getWidth() - 2;
        int h = this.computePopupHeightForRowCount(this.selectionField.getMaximumRowCount());
        if (this.selectionField.label != null) {
            int labelWidth = this.selectionField.label.getWidth();
            x += labelWidth;
            w -= labelWidth;
        }
        Rectangle popupBounds = this.computePopupBounds(x, y, w, h);
        Dimension popupSize = popupBounds.getSize();
        this.scroller.setMaximumSize(popupSize);
        this.scroller.setPreferredSize(popupSize);
        this.scroller.setMinimumSize(popupSize);
        this.list.invalidate();
        this.updateListIndex();
        this.show(this.selectionField, popupBounds.x, popupBounds.y);
        this.list.requestFocus();
        this.selectionField.firePopup(2);
    }

    public void cancelPopup() {
        this.list.setSelectedIndex(-1);
        if (this.isVisible()) {
            this.hidePopup();
        }
    }

    public void hidePopup() {
        this.selectionField.notifyPopupClosed();
        this.selectionField.firePopup(3);
        this.setVisible(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JSelectionPopup.this.selectionField.repaint();
                JSelectionPopup.this.selectionField.requestFocus();
            }
        });
        this.selectionField.firePopup(4);
    }

    void acceptSelection() {
        this.updateSelectionFieldIndex();
        this.cancelPopup();
    }

    void updateListIndex() {
        int selectedIndex = this.selectionField.getSelectedIndex();
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
        }
        this.list.ensureIndexIsVisible(selectedIndex);
    }

    void updateSelectionFieldIndex() {
        int index = this.list.getSelectedIndex();
        if (index >= 0) {
            this.selectionField.setSelectedIndex(index);
            this.selectionField.fireActionPerformed();
        }
    }

    protected int computePopupHeightForRowCount(int maxRowCount) {
        ListCellRenderer renderer = this.list.getCellRenderer();
        int n = this.selectionField.getNumberOfItems();
        int rowCount = Math.min(maxRowCount, n);
        int height = 0;
        for (int i = 0; i < rowCount; ++i) {
            Object value = this.list.getModel().getElementAt(i);
            if (value == null) {
                value = "x";
            }
            Component c = renderer.getListCellRendererComponent(this.list, value, i, false, false);
            height += c.getPreferredSize().height;
        }
        return height == 0 ? 100 : height;
    }

    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        Container container = SwingUtilities.getAncestorOfClass(JScrollPane.class, this.selectionField);
        if (container == null) {
            container = SwingUtilities.getWindowAncestor(this.selectionField);
        }
        Point containerLocation = container.getLocationOnScreen();
        int minY = containerLocation.y;
        int maxY = containerLocation.y + container.getHeight();
        Point selectionLocation = this.selectionField.getLocationOnScreen();
        int endy = selectionLocation.y + py + ph;
        if (endy < maxY) {
            return new Rectangle(px, py, pw, ph);
        }
        int starty = selectionLocation.y + py + ph - 1;
        if (starty > minY) {
            return new Rectangle(px, -ph - 1, pw, ph);
        }
        int diffBelow = maxY - py;
        int diffAbove = selectionLocation.y - minY - 1;
        if (diffBelow > diffAbove) {
            return new Rectangle(px, py, pw, diffBelow);
        }
        return new Rectangle(px, -diffAbove - 1, pw, diffAbove);
    }

    protected void updateListBoxSelectionForEvent(MouseEvent e) {
        Point location = e.getPoint();
        if (this.list == null) {
            return;
        }
        int index = this.list.locationToIndex(location);
        if (index == -1) {
            index = location.y < 0 ? 0 : this.selectionField.getNumberOfItems() - 1;
        }
        if (this.list.getSelectedIndex() != index) {
            this.list.setSelectedIndex(index);
        }
    }

    public class ListFocusHandler
    extends FocusAdapter {
        @Override
        public void focusLost(FocusEvent e) {
            JSelectionPopup.this.cancelPopup();
        }
    }

    public class ListKeyHandler
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                if (JSelectionPopup.this.isVisible()) {
                    JSelectionPopup.this.acceptSelection();
                } else {
                    JSelectionPopup.this.showPopup();
                }
                e.consume();
                return;
            }
            if (e.getKeyCode() == 27) {
                JSelectionPopup.this.cancelPopup();
                e.consume();
                return;
            }
            if (e.getKeyCode() == 9) {
                JSelectionPopup.this.acceptSelection();
                e.consume();
                return;
            }
        }
    }

    protected class ListMouseHandler
    extends MouseInputAdapter {
        protected ListMouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JSelectionPopup.this.acceptSelection();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point location = e.getPoint();
            Rectangle r = new Rectangle();
            JSelectionPopup.this.list.computeVisibleRect(r);
            if (r.contains(location)) {
                JSelectionPopup.this.updateListBoxSelectionForEvent(e);
            }
        }
    }
}

