/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.splash;

import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JWindow;
import org.openbp.swing.components.splash.Progressable;

public abstract class Splash
extends JWindow {
    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.layoutWindow();
        }
        super.setVisible(visible);
    }

    protected abstract Progressable getMainComponent();

    protected abstract Progressable[] getSectionComponents();

    public void setProgressTo(int section, double value) {
        Progressable[] comps = this.getSectionComponents();
        if (comps != null && comps.length > 0) {
            if (comps.length < section || value < 0.0 || value > 1.0) {
                return;
            }
            comps[section - 1].setProgress(value);
            this.updateMainProgress();
        }
    }

    private void updateMainProgress() {
        Progressable[] comps = this.getSectionComponents();
        if (comps != null && comps.length > 0) {
            int fail = 0;
            int count = comps.length;
            double value = 0.0;
            for (int i = 0; i < count; ++i) {
                double d = comps[i].getProgress();
                if (d < 0.0 || d > 1.0) {
                    ++fail;
                    continue;
                }
                value += d;
            }
            this.getMainComponent().setProgress(value /= (double)(count - fail));
        }
    }

    private void layoutWindow() {
        Rectangle maincomponent = new Rectangle();
        JComponent maincomp = this.getMainComponent().getProgressableComponent();
        maincomponent.width += maincomp.getWidth();
        maincomponent.height += maincomp.getHeight();
        this.getContentPane().add(maincomp);
        this.pack();
        this.setLocationRelativeTo(null);
    }
}

