/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

public class DefaultTreeNode
implements TreeNode {
    protected TreeNode parent;
    private List childList;

    public DefaultTreeNode() {
    }

    public DefaultTreeNode(TreeNode parent) {
        this.parent = parent;
    }

    public Enumeration children() {
        return Collections.enumeration(this.childList);
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        if (this.childList != null) {
            return this.childList.indexOf(treeNode);
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return this.childList == null || this.childList.size() == 0;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (this.childList != null && index >= 0 && index < this.childList.size()) {
            return (TreeNode)this.childList.get(index);
        }
        return null;
    }

    @Override
    public int getChildCount() {
        return this.childList != null ? this.childList.size() : 0;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public void addChild(DefaultTreeNode child) {
        if (this.childList == null) {
            this.childList = new ArrayList();
        }
        this.childList.add(child);
        child.setParent(this);
    }

    public void insertChild(DefaultTreeNode child, int index) {
        if (this.childList == null) {
            this.addChild(child);
            return;
        }
        this.childList.add(index, child);
        child.setParent(this);
    }

    public void removeChild(DefaultTreeNode child) {
        if (this.childList != null) {
            child.setParent(null);
            this.childList.remove(child);
        }
    }

    public void clearChilds() {
        this.childList = null;
    }

    public List getChildList() {
        return this.childList;
    }

    public void setChildList(List childList) {
        this.childList = childList;
    }
}

