/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.tree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeExpander {
    private JTree tree;

    public TreeExpander(JTree tree) {
        this.tree = tree;
    }

    public void simpleExpand(int level) {
        this.expandLevel(0);
        if (this.tree.getRowCount() == 0 || level == 0) {
            return;
        }
        this.simpleExpandLevel(1, level);
    }

    private void simpleExpandLevel(int currentlevel, int maxlevel) {
        if (currentlevel > maxlevel) {
            return;
        }
        int rowsToExpand = this.getRowsToExpand();
        if (rowsToExpand <= 0) {
            return;
        }
        List childrenOfLevel = this.getNodesOfLevel(currentlevel);
        if (childrenOfLevel.size() > rowsToExpand || childrenOfLevel.size() == 0) {
            return;
        }
        this.expandLevel(currentlevel);
        this.simpleExpandLevel(currentlevel + 1, maxlevel);
    }

    private List getNodesOfLevel(int level) {
        return this.getNodesOfLevel((TreeNode)this.tree.getModel().getRoot(), level);
    }

    private List getNodesOfLevel(TreeNode parent, int level) {
        if (level == 0) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>();
            for (int i = 0; i < parent.getChildCount(); ++i) {
                children.add(parent.getChildAt(i));
            }
            return children;
        }
        ArrayList children = new ArrayList();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            children.addAll(this.getNodesOfLevel(parent.getChildAt(i), level - 1));
        }
        return children;
    }

    public void intelliExpand(int level) {
        this.expandLevel(0);
        if (this.tree.getRowCount() == 0) {
            return;
        }
        int rowsToExpand = this.getRowsToExpand();
        if (rowsToExpand < 2) {
            return;
        }
        TreeNode rootNode = (TreeNode)this.tree.getModel().getRoot();
        TreeNode[] nodes = this.getPossibleExpandNodes(rootNode, rowsToExpand);
        TreePath parent = new TreePath(rootNode);
        this.expandRows(parent, nodes);
        if (level == 0) {
            return;
        }
        this.intelliExpandLevel(parent, level - 1);
    }

    private void intelliExpandLevel(TreePath parentPath, int level) {
        TreeNode child;
        int i;
        int rowsToExpand = this.getRowsToExpand();
        if (rowsToExpand <= 0 || level < 0) {
            return;
        }
        Object[] pathArray = this.createPathArray(parentPath);
        TreeNode parentNode = (TreeNode)parentPath.getLastPathComponent();
        for (i = 0; i < parentNode.getChildCount(); ++i) {
            child = parentNode.getChildAt(i);
            TreeNode[] nodesToExpand = this.getPossibleExpandNodes(child, rowsToExpand);
            if (nodesToExpand.length != 0) {
                pathArray[pathArray.length - 1] = child;
                this.expandRows(new TreePath(pathArray), nodesToExpand);
                rowsToExpand = this.getRowsToExpand();
            }
            if (rowsToExpand <= 0) break;
        }
        if ((rowsToExpand = this.getRowsToExpand()) <= 0) {
            return;
        }
        pathArray = this.createPathArray(parentPath);
        for (i = 0; i < parentNode.getChildCount(); ++i) {
            child = parentNode.getChildAt(i);
            pathArray[pathArray.length - 1] = child;
            this.intelliExpandLevel(new TreePath(pathArray), level - 1);
            rowsToExpand = this.getRowsToExpand();
            if (rowsToExpand <= 0) break;
        }
    }

    public void expandLevel(int level) {
        TreeNode rootNode = (TreeNode)this.tree.getModel().getRoot();
        this.expandLevel(new TreePath(rootNode), level - 1);
    }

    private void expandLevel(TreePath parentPath, int level) {
        Object[] pathArray = this.createPathArray(parentPath);
        TreeNode parentNode = (TreeNode)parentPath.getLastPathComponent();
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            TreeNode child;
            pathArray[pathArray.length - 1] = child = parentNode.getChildAt(i);
            TreePath currentPath = new TreePath(pathArray);
            if (level < 0) {
                this.collapsePath(currentPath);
                this.tree.collapsePath(new TreePath(pathArray));
                continue;
            }
            this.tree.expandPath(new TreePath(pathArray));
            this.expandLevel(new TreePath(pathArray), level - 1);
        }
    }

    private void collapsePath(TreePath parentPath) {
        Object[] pathArray = this.createPathArray(parentPath);
        TreeNode parentNode = (TreeNode)parentPath.getLastPathComponent();
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            TreeNode child;
            pathArray[pathArray.length - 1] = child = parentNode.getChildAt(i);
            TreePath currentPath = new TreePath(pathArray);
            this.collapsePath(currentPath);
            this.tree.collapsePath(currentPath);
        }
    }

    private int getMaxDisplayedRows(int currentlyDisplayedRows) {
        int height = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getHeight() : this.tree.getHeight();
        return height / (this.tree.getPreferredSize().height / currentlyDisplayedRows);
    }

    private int getRowsToExpand() {
        int displayedRows = this.tree.getRowCount();
        int maxDisplayable = this.getMaxDisplayedRows(displayedRows);
        return maxDisplayable - displayedRows;
    }

    private TreeNode[] createPathArray(TreePath parent) {
        Object[] oPath = parent.getPath();
        TreeNode[] nodePath = new TreeNode[oPath.length + 1];
        System.arraycopy(oPath, 0, nodePath, 0, oPath.length);
        return nodePath;
    }

    private void expandRows(TreePath parent, TreeNode[] nodes) {
        Object[] oPath = parent.getPath();
        Object[] nodePath = new TreeNode[oPath.length + 1];
        System.arraycopy(oPath, 0, nodePath, 0, oPath.length);
        for (int i = 0; i < nodes.length; ++i) {
            nodePath[oPath.length] = nodes[i];
            TreePath path = new TreePath(nodePath);
            this.tree.expandPath(path);
        }
    }

    private TreeNode[] getPossibleExpandNodes(TreeNode node, int rowsToDisplay) {
        List expand2;
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            if (!child.isLeaf()) continue;
            --rowsToDisplay;
        }
        if (rowsToDisplay <= 0) {
            return new TreeNode[0];
        }
        List<TreeRow> expand = new ArrayList();
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            nodes.add(node.getChildAt(i));
            TreeRow row = new TreeRow();
            row.addRow(node.getChildAt(i));
            if (row.getRowSum() > rowsToDisplay || row.getRowSum() == 0) continue;
            expand.add(row);
        }
        while ((expand2 = this.addNewRow(nodes, expand, rowsToDisplay)).size() != 0) {
            expand = expand2;
        }
        if (expand.size() != 0) {
            return ((TreeRow)expand.get(0)).getNodes();
        }
        return new TreeNode[0];
    }

    private List addNewRow(List nodes, List expand, int rowsToDisplay) {
        ArrayList<TreeRow> expand2 = new ArrayList<TreeRow>();
        for (int i = 0; i < expand.size(); ++i) {
            for (int j = 0; j < nodes.size(); ++j) {
                TreeNode node;
                TreeRow r1 = (TreeRow)expand.get(i);
                if (r1.containsNode(node = (TreeNode)nodes.get(j))) continue;
                TreeRow row = new TreeRow();
                row.addRow(r1);
                row.addRow(node);
                if (row.getRowSum() > rowsToDisplay || this.hasListRows(expand2, row)) continue;
                expand2.add(row);
            }
        }
        return expand2;
    }

    private boolean hasListRows(List expand, TreeRow row) {
        for (int i = 0; i < expand.size(); ++i) {
            TreeRow rowExpand = (TreeRow)expand.get(i);
            if (!rowExpand.hasNodes(row.getNodes())) continue;
            return true;
        }
        return false;
    }

    public static class TreeRow {
        private List nodeList = new ArrayList();
        private int rowSum = 0;

        public void addRow(TreeNode node) {
            this.nodeList.add(node);
            this.rowSum += node.getChildCount();
        }

        public void addRow(TreeRow row) {
            this.nodeList.addAll(row.nodeList);
            this.rowSum += row.rowSum;
        }

        public TreeNode[] getNodes() {
            return this.nodeList.toArray(new TreeNode[this.nodeList.size()]);
        }

        public int getRowSum() {
            return this.rowSum;
        }

        public boolean containsNode(TreeNode node) {
            return this.nodeList.contains(node);
        }

        public boolean hasNodes(TreeNode[] nodes) {
            for (int i = 0; i < nodes.length; ++i) {
                if (this.containsNode(nodes[i])) continue;
                return false;
            }
            return true;
        }
    }
}

