/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.treetable;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.openbp.common.string.TextUtil;

public class DefaultTableCellRenderer
extends javax.swing.table.DefaultTableCellRenderer {
    private static final EmptyBorder distanceBorder = new EmptyBorder(1, 0, 0, 0);
    private String[] singleLineText = new String[1];

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(value instanceof JComponent)) {
            JLabel l = new JLabel();
            this.processLabelAttributes(l, table, isSelected, hasFocus, row, column);
            if (value != null) {
                if (value instanceof String[]) {
                    String[] multiText = (String[])value;
                    String text = multiText[0];
                    if (text != null) {
                        text = " " + text;
                    }
                    l.setText(text);
                    l.setToolTipText(TextUtil.convertToHTML((String[])multiText, (boolean)false, (int)0, (int)50));
                } else {
                    String text = value.toString();
                    if (text != null) {
                        text = " " + text;
                        l.setText(text);
                        if (text.length() > 40) {
                            this.singleLineText[0] = text;
                            l.setToolTipText(TextUtil.convertToHTML((String[])this.singleLineText, (boolean)false, (int)0, (int)50));
                        }
                    }
                }
            }
            l.setVerticalAlignment(1);
            return l;
        }
        return (Component)value;
    }

    public void processLabelAttributes(JLabel label, JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
        Color back;
        if (isSelected) {
            label.setForeground(table.getSelectionForeground());
            label.setBackground(table.getSelectionBackground());
        } else {
            label.setForeground(table.getForeground());
            label.setBackground(table.getBackground());
        }
        label.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                label.setForeground(UIManager.getColor("Table.focusCellForeground"));
                label.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        boolean colorMatch = (back = label.getBackground()) != null && back.equals(table.getBackground()) && table.isOpaque();
        label.setOpaque(!colorMatch);
        label.setBorder(distanceBorder);
    }
}

