/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.treetable;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import org.openbp.swing.components.treetable.JTreeTable;
import org.openbp.swing.components.treetable.TreeTableNode;

public class DefaultTreeCellRenderer
extends javax.swing.tree.DefaultTreeCellRenderer {
    public JTreeTable treeTable;

    public DefaultTreeCellRenderer(JTreeTable treeTable) {
        this.treeTable = treeTable;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component component = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            if (value instanceof TreeTableNode) {
                TreeTableNode node = (TreeTableNode)value;
                String text = node.getNodeText();
                label.setText(text);
                label.setToolTipText(text);
                Dimension labelMinSize = label.getMinimumSize();
                Dimension labelPrefSize = label.getPreferredSize();
                int defaultRowHeight = this.treeTable.getDefaultRowHeight();
                int nodeHeight = node.getPreferredSize().height;
                Icon icon = node.isLeaf() ? this.leafIcon : (expanded ? this.openIcon : this.closedIcon);
                int iconHeight = icon != null ? icon.getIconHeight() : 0;
                int height = labelMinSize.height;
                height = Math.max(height, nodeHeight);
                height = Math.max(height, defaultRowHeight);
                height = Math.max(height, iconHeight);
                int width = Math.max(labelMinSize.width, labelPrefSize.width);
                label.setPreferredSize(new Dimension(width -= 3, height));
                node.setLastHeight(height);
                label.setVerticalAlignment(1);
            }
            return label;
        }
        return component;
    }
}

