/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.treetable;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openbp.common.CollectionUtil;
import org.openbp.common.listener.ListenerSupport;
import org.openbp.common.string.TextUtil;
import org.openbp.swing.components.tree.TreeUtil;
import org.openbp.swing.components.treetable.DefaultTableCellEditor;
import org.openbp.swing.components.treetable.DefaultTableCellRenderer;
import org.openbp.swing.components.treetable.DefaultTreeTableModel;
import org.openbp.swing.components.treetable.DefaultTreeTableNode;
import org.openbp.swing.components.treetable.TreeTableCellEditor;
import org.openbp.swing.components.treetable.TreeTableCellRenderer;
import org.openbp.swing.components.treetable.TreeTableEvent;
import org.openbp.swing.components.treetable.TreeTableListener;
import org.openbp.swing.components.treetable.TreeTableModel;
import org.openbp.swing.components.treetable.TreeTableModelListener;
import org.openbp.swing.components.treetable.TreeTableNode;
import org.openbp.swing.components.treetable.resize.ColumnSizeConstraint;
import org.openbp.swing.components.treetable.resize.RatioConstraint;

public class JTreeTable
extends JTable
implements MouseListener {
    public static final int SELECTION_NONE = 0;
    public static final int SELECTION_SINGLE = 0;
    public static final int SELECTION_MULTI = 2;
    public static final int CMD_NONE = 0;
    public static final int CMD_MOUSE = 1;
    public static final int CMD_TAB = 2;
    public static final int CMD_BACKTAB = 3;
    public static final int CMD_ENTER = 4;
    public static final int CMD_SPACE = 5;
    public static final int CMD_LEFT = 6;
    public static final int CMD_RIGHT = 7;
    public static final int CMD_UP = 8;
    public static final int CMD_DOWN = 9;
    public static final int CMD_PGUP = 10;
    public static final int CMD_PGDN = 11;
    public static final int CMD_TOP = 12;
    public static final int CMD_BOTTOM = 13;
    public static final int CMD_HOME = 14;
    public static final int CMD_END = 15;
    public static final int CMD_ESC = 16;
    public static final int CMD_SET_SELECTION = 1024;
    public static final int CMD_EXTEND_SELECTION = 2048;
    public static final int CMD_TOGGLE_SELECTION = 4096;
    public static final int CMD_SWITCH_TREE = 8192;
    public static final int CMD_CODE_MASK = 255;
    public static final int CMD_SELECTION_MASK = 7168;
    private TreeTableCellRenderer tree;
    private static DefaultTableCellRenderer defaultTableRenderer;
    private static DefaultTableCellEditor defaultTableCellEditor;
    protected InputMap focusInputMap;
    protected InputMap focusAncestorInputMap;
    protected ActionMap actionMap;
    protected ListenerSupport listenerSupport;
    private int defaultRowHeight;
    private int treeCol;
    protected int currentCol = -1;
    protected int currentRow = -1;
    private int savedCurrentCol = -1;
    private int savedCurrentRow = -1;
    private boolean performingEditCellAt;
    private int selectionMode = 0;
    private ColumnSizeConstraint csc;
    private static int actionIdCounter;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int UP = 3;
    private static final int DOWN = 4;

    public JTreeTable() {
        DefaultTreeTableNode rootNode = new DefaultTreeTableNode();
        rootNode.addColumn("Root Node");
        DefaultTreeTableModel model = new DefaultTreeTableModel(rootNode);
        this.init(model);
    }

    public JTreeTable(TreeTableModel treeTableModel) {
        this.init(treeTableModel);
    }

    private void init(TreeTableModel treeTableModel) {
        this.defaultRowHeight = 16;
        this.tree = new TreeTableCellRenderer(this, treeTableModel);
        this.tree.setToggleClickCount(2);
        treeTableModel.setTreeTable(this);
        treeTableModel.addTreeModelListener(new TTModelListener());
        super.setModel(treeTableModel);
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor(this));
        if (defaultTableRenderer == null) {
            defaultTableRenderer = new DefaultTableCellRenderer();
        }
        this.setDefaultRenderer(String.class, defaultTableRenderer);
        this.setDefaultRenderer(String[].class, defaultTableRenderer);
        this.setDefaultRenderer(Object.class, defaultTableRenderer);
        if (defaultTableCellEditor == null) {
            defaultTableCellEditor = new DefaultTableCellEditor();
        }
        this.setDefaultEditor(Object.class, defaultTableCellEditor);
        this.getSelectionModel().setSelectionMode(this.selectionMode);
        this.setRowSelectionAllowed(true);
        RatioConstraint csc = new RatioConstraint(true);
        csc.addMaxSizeForColumn(0, 0.5);
        this.setAutoResizeMode(1);
        this.setColumnSizeConstraint(csc);
        this.setShowGrid(false);
        this.addMouseListener(this);
        this.setupKeyBindings();
        this.setSurrendersFocusOnKeystroke(true);
        this.configureSubComponent(this);
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object ret = super.getValueAt(row, column);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            if (this.getDefaultEditor(TreeTableModel.class) == null) {
                this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor(this));
            }
            this.tree.updateUI();
        }
    }

    @Override
    public boolean editCellAt(int row, int col) {
        return this.editCellAt(row, col, null);
    }

    @Override
    public boolean editCellAt(int row, int col, EventObject e) {
        this.performingEditCellAt = true;
        boolean success = super.editCellAt(row, col, e);
        this.performingEditCellAt = false;
        if (success && this.editorComp instanceof JComponent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (JTreeTable.this.editorComp != null) {
                        JTreeTable.this.editorComp.requestFocus();
                    }
                }
            });
        }
        return success;
    }

    @Override
    public void changeSelection(int newRow, int newCol, boolean toggle, boolean extend) {
        TableCellEditor cellEditor;
        if (this.currentCol >= 0 && this.currentRow >= 0 && (cellEditor = this.getCellEditor(this.currentRow, this.currentCol)) != null) {
            cellEditor.stopCellEditing();
        }
        if (!this.performingEditCellAt) {
            this.editCellAt(newRow, newCol);
        }
        super.changeSelection(newRow, newCol, toggle, extend);
        this.tree.setSelectionRow(newRow);
        if (this.currentCol >= 0 && this.currentRow >= 0) {
            final int oldCol = this.currentCol;
            final int oldRow = this.currentRow;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTreeTable.this.repaintCell(oldRow, oldCol);
                }
            });
        }
        this.currentCol = newCol;
        this.currentRow = newRow;
    }

    protected void repaintCell(int row, int col) {
        Rectangle dirtyRect = this.getCellRect(row, col, false);
        this.repaint(dirtyRect);
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    public void setModel(TreeTableModel model) {
        this.tree.setModel(model);
        model.setTreeTable(this);
        super.setModel(model);
    }

    @Override
    public String getToolTipText(MouseEvent me) {
        TableCellRenderer renderer;
        Component component;
        String tip = null;
        Point p = me.getPoint();
        int hitColumnIndex = this.columnAtPoint(p);
        int hitRowIndex = this.rowAtPoint(p);
        if (hitColumnIndex != -1 && hitRowIndex != -1 && (component = this.prepareRenderer(renderer = this.getCellRenderer(hitRowIndex, hitColumnIndex), hitRowIndex, hitColumnIndex)) instanceof JComponent) {
            if (!(component instanceof TreeTableCellRenderer)) {
                Rectangle cellRect = this.getCellRect(hitRowIndex, hitColumnIndex, false);
                p.translate(-cellRect.x, -cellRect.y);
            }
            MouseEvent newEvent = new MouseEvent(component, me.getID(), me.getWhen(), me.getModifiers(), p.x, p.y, me.getClickCount(), me.isPopupTrigger());
            tip = ((JComponent)component).getToolTipText(newEvent);
        }
        if (tip == null) {
            tip = this.getToolTipText();
        }
        return tip;
    }

    public JTree getTree() {
        return this.tree;
    }

    public TreeTableModel getTreeTableModel() {
        return (TreeTableModel)this.dataModel;
    }

    protected JScrollPane getScrollPane() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            return (JScrollPane)gp;
        }
        return null;
    }

    public void setRootVisible(boolean visible) {
        this.tree.setRootVisible(visible);
    }

    public int getTreeCol() {
        return this.treeCol;
    }

    public int getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public void setDefaultRowHeight(int defaultRowHeight) {
        this.defaultRowHeight = defaultRowHeight;
    }

    public void sizeRowsToFit() {
        if (this.tree == null) {
            return;
        }
        int numberOfRows = this.tree.getRowCount();
        for (int i = 0; i < numberOfRows; ++i) {
            TreeTableNode node;
            TreePath path = this.tree.getPathForRow(i);
            if (path == null || (node = (TreeTableNode)path.getLastPathComponent()).getLastHeight() <= 0) continue;
            this.setRowHeight(i, node.getLastHeight());
        }
        this.revalidate();
        this.repaint();
    }

    public void sizeColumnsToFit() {
        this.sizeColumnsToFit(-1);
    }

    @Override
    public void sizeColumnsToFit(int resizingColumn) {
        if (resizingColumn >= 0) {
            super.sizeColumnsToFit(resizingColumn);
            return;
        }
        if (this.tree == null) {
            return;
        }
        JTableHeader header = this.getTableHeader();
        if (header != null && header.getResizingColumn() != null) {
            return;
        }
        if (!this.csc.isRecalculateNeeded(this)) {
            return;
        }
        int total = this.getWidth();
        if (total <= 0) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                column.setMinWidth(this.csc.getAbsoluteMinimum());
            }
            return;
        }
        this.csc.calculateColumnSizes(this);
        int treePref = this.csc.determineMaxTreeColumnWidth(this);
        if (treePref <= 0) {
            return;
        }
        this.csc.adjustMaximalWidthOfColumn(this);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            column.setMaxWidth(this.csc.getMaxWidthOfColumn(i));
            column.setMinWidth(this.csc.getMinWidthOfColumn(i));
            column.setPreferredWidth(this.csc.getPreferredWidthOfColumn(i));
        }
    }

    public void setColumnSizeConstraint(ColumnSizeConstraint csc) {
        this.csc = csc;
    }

    @Override
    public void doLayout() {
        JTableHeader header = this.getTableHeader();
        if (header != null && header.getResizingColumn() == null) {
            this.sizeColumnsToFit();
            int count = this.getColumnModel().getColumnCount();
            for (int i = 0; i < count; ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                column.setWidth(column.getPreferredWidth());
            }
            this.resizeAndRepaint();
            this.getParent().doLayout();
        } else {
            super.doLayout();
        }
    }

    public TreePath getPathByRow(int row) {
        return row >= 0 ? this.tree.getPathForRow(row) : null;
    }

    public TreePath getPathByNode(TreeNode treeNode) {
        int rows = this.tree.getRowCount();
        for (int i = 0; i < rows; ++i) {
            TreePath path = this.tree.getPathForRow(i);
            if (path.getLastPathComponent() != treeNode) continue;
            return path;
        }
        return null;
    }

    public TreePath getPathByPoint(Point point) {
        Point treePoint = this.convertTableToTreePoint(point);
        if (treePoint == null) {
            return null;
        }
        TreePath path = this.tree.getClosestPathForLocation(treePoint.x, treePoint.y);
        return path;
    }

    public TreeTableNode getNodeByRow(int row) {
        return this.getNodeByPath(this.getPathByRow(row));
    }

    public TreeTableNode getNodeByPath(TreePath path) {
        return path != null ? (TreeTableNode)path.getLastPathComponent() : null;
    }

    public TreeTableNode getNodeByPoint(Point point) {
        return this.getNodeByPath(this.getPathByPoint(point));
    }

    public int getRowByPath(TreePath path) {
        return path != null ? this.tree.getRowForPath(path) : -1;
    }

    public int getFirstVisibleRow() {
        JScrollPane scrollPane = this.getScrollPane();
        if (scrollPane == null) {
            return this.tree.getRowCount() > 0 ? 0 : -1;
        }
        Rectangle viewRect = scrollPane.getViewport().getViewRect();
        int y = viewRect.y;
        int rowHeight = this.getRowHeight(0);
        Point pos = new Point(0, y += rowHeight / 2);
        TreePath path = this.getPathByPoint(pos);
        if (path == null) {
            return -1;
        }
        int row = this.tree.getRowForPath(path);
        return row;
    }

    public int getLastVisibleRow() {
        JScrollPane scrollPane = this.getScrollPane();
        if (scrollPane == null) {
            return this.tree.getRowCount() - 1;
        }
        Rectangle viewRect = scrollPane.getViewport().getViewRect();
        int y = viewRect.y + viewRect.height;
        int rowHeight = this.getRowHeight(0);
        Point pos = new Point(0, y -= rowHeight / 2);
        TreePath path = this.getPathByPoint(pos);
        if (path == null) {
            return -1;
        }
        int row = this.tree.getRowForPath(path);
        return row;
    }

    public int getVisibleRowCount() {
        int last = this.getLastVisibleRow();
        if (last < 0) {
            return 0;
        }
        int first = this.getFirstVisibleRow();
        int n = last - first + 1;
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    public void configureSubComponent(JComponent comp) {
        comp.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        comp.setFocusTraversalKeys(1, Collections.EMPTY_SET);
    }

    public boolean isCellSelectable(int row, int col) {
        return this.getTreeTableModel().isCellSelectable(row, this.convertColumnIndexToModel(col));
    }

    public void selectCell(int newRow, int newCol) {
        this.changeSelection(newRow, newCol, false, false);
    }

    public boolean selectDefaultCell() {
        if (!this.selectDefaultCell(false)) {
            return this.selectDefaultCell(true);
        }
        return true;
    }

    public boolean selectDefaultCell(boolean treeCell) {
        int colCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < colCount; ++col) {
                if (!(treeCell ? col == this.treeCol : col != this.treeCol) || !this.isCellSelectable(row, col)) continue;
                this.selectCell(row, col);
                return true;
            }
        }
        return false;
    }

    public boolean selectNode(TreeNode node) {
        TreePath path = this.getPathByNode(node);
        if (path == null) {
            return false;
        }
        this.selectCell(this.tree.getRowForPath(path), this.treeCol);
        return true;
    }

    public TreePath[] getSelection() {
        ListSelectionModel selectionModel = this.getSelectionModel();
        int min = selectionModel.getMinSelectionIndex();
        int max = selectionModel.getMaxSelectionIndex();
        if (min >= 0) {
            ArrayList<TreePath> paths = new ArrayList<TreePath>();
            for (int i = min; i <= max; ++i) {
                if (!selectionModel.isSelectedIndex(i)) continue;
                paths.add(this.tree.getPathForRow(i));
            }
            return (TreePath[])CollectionUtil.toArray(paths, TreePath.class);
        }
        return null;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        this.getSelectionModel().setSelectionMode(selectionMode);
    }

    public void saveCurrentPosition() {
        this.savedCurrentCol = this.currentCol;
        this.savedCurrentRow = this.currentRow;
    }

    public void restoreCurrentPosition() {
        if (this.savedCurrentCol != -1) {
            this.selectCell(this.savedCurrentRow, this.savedCurrentCol);
            this.savedCurrentRow = -1;
            this.savedCurrentCol = -1;
        }
    }

    public void expandTreeLevels(boolean expand, int numberOfLevelThatAreNeededToBeExpanded) {
        TreeUtil.expandTreeLevels(this.tree, expand, numberOfLevelThatAreNeededToBeExpanded);
        this.sizeRowsToFit();
        this.sizeColumnsToFit();
    }

    public void expandAll(boolean expand) {
        this.expandTreeLevels(expand, -1);
    }

    public void expandAll(TreePath parent, boolean expand) {
        this.expandTreeLevels(parent, expand, -1);
    }

    public void expandTreeLevels(TreePath parent, boolean expand, int numberOfLevelThatAreNeededToBeExpanded) {
        TreeUtil.expandTreeLevels(this.tree, parent, expand, numberOfLevelThatAreNeededToBeExpanded);
        this.sizeRowsToFit();
        this.sizeColumnsToFit();
    }

    public void toggleRow(int row) {
        TreePath path = this.tree.getPathForRow(row);
        this.togglePath(path);
    }

    public void togglePath(TreePath path) {
        if (this.tree.isCollapsed(path)) {
            this.expandPath(path);
        } else {
            this.collapsePath(path);
        }
    }

    public void collapseRow(int row) {
        this.tree.collapseRow(row);
    }

    public void expandRow(int row) {
        this.tree.expandRow(row);
    }

    public void collapsePath(TreePath path) {
        this.tree.collapsePath(path);
    }

    public void expandPath(TreePath path) {
        this.tree.expandPath(path);
    }

    private void setupKeyBindings() {
        if (this.focusInputMap != null) {
            return;
        }
        this.focusInputMap = new InputMap();
        this.focusInputMap.setParent(SwingUtilities.getUIInputMap(this, 0));
        this.focusAncestorInputMap = new InputMap();
        this.focusAncestorInputMap.setParent(SwingUtilities.getUIInputMap(this, 1));
        this.actionMap = new ActionMap();
        this.actionMap.setParent(SwingUtilities.getUIActionMap(this));
        this.defineKey(10, 0, 4);
        this.defineKey(9, 0, 2);
        this.defineKey(9, 1, 3);
        this.defineKey(32, 0, 5);
        this.defineKey(37, 0, 6);
        this.defineKey(39, 0, 7);
        this.defineKey(37, 2, 8198);
        this.defineKey(39, 2, 8199);
        this.defineKey(38, 0, 8);
        this.defineKey(40, 0, 9);
        this.defineKey(33, 0, 10);
        this.defineKey(34, 0, 11);
        this.defineKey(33, 2, 12);
        this.defineKey(34, 2, 13);
        this.defineKey(36, 0, 8206);
        this.defineKey(35, 0, 8207);
        this.defineKey(27, 0, 16);
        SwingUtilities.replaceUIInputMap(this, 0, this.focusInputMap);
        SwingUtilities.replaceUIInputMap(this, 1, this.focusAncestorInputMap);
        SwingUtilities.replaceUIActionMap(this, this.actionMap);
    }

    private void defineKey(int keyCode, int keyModifier, int command) {
        String actionId = "TT" + actionIdCounter++;
        KeyStroke ks = KeyStroke.getKeyStroke(keyCode, keyModifier);
        this.focusInputMap.put(ks, actionId);
        this.focusAncestorInputMap.put(ks, actionId);
        this.actionMap.put(actionId, new CommandAction(actionId, command));
    }

    public void handleKeyEvent(KeyEvent e) {
        this.processKeyEvent(e);
        e.consume();
    }

    protected void processCommand(int command) {
        int row;
        if (this.fireCommand(command)) {
            return;
        }
        int colCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        int minCol = this.treeCol;
        int maxCol = colCount - 1;
        int col = this.currentCol;
        if (col < 0 && (col = this.getSelectedColumn()) < 0) {
            col = 0;
        }
        if ((row = this.currentRow) < 0 && (row = this.getSelectedRow()) < 0) {
            row = 0;
        }
        if (command == 2 || command == 3) {
            minCol = 1;
        } else if ((command & 0x2000) != 0) {
            if (col == this.treeCol) {
                minCol = this.treeCol + 1;
            } else {
                maxCol = this.treeCol;
            }
        } else if (col == this.treeCol) {
            maxCol = this.treeCol;
        } else {
            minCol = this.treeCol + 1;
        }
        if (col < 0) {
            col = 0;
        }
        if (row < 0) {
            row = 0;
        }
        if ((command &= 0xFF) == 0) {
            return;
        }
        int direction = 0;
        boolean wrap = false;
        if (col == this.treeCol && minCol == this.treeCol && (command == 4 || command == 5 || command == 6 || command == 7)) {
            TreePath path = this.tree.getPathForRow(row);
            if (path != null) {
                TreeTableNode node = (TreeTableNode)path.getLastPathComponent();
                boolean isFolder = !node.isLeaf();
                switch (command) {
                    case 4: {
                        if (isFolder) {
                            this.expandPath(path);
                        }
                        if (row + 1 < rowCount) {
                            ++row;
                        }
                        direction = 4;
                        wrap = true;
                        break;
                    }
                    case 5: {
                        if (!isFolder) break;
                        this.togglePath(path);
                        break;
                    }
                    case 6: {
                        if (isFolder && !this.tree.isCollapsed(path)) {
                            this.collapsePath(path);
                        } else {
                            TreePath parentPath = path.getParentPath();
                            row = this.tree.getRowForPath(parentPath);
                            if (row < 0) {
                                row = 0;
                            }
                        }
                        direction = 3;
                        break;
                    }
                    case 7: {
                        if (isFolder && this.tree.isCollapsed(path)) {
                            this.expandPath(path);
                        } else if (row + 1 < rowCount) {
                            ++row;
                        }
                        direction = 4;
                    }
                }
            }
        } else {
            switch (command) {
                case 5: {
                    return;
                }
                case 2: 
                case 4: {
                    ++col;
                    direction = 2;
                    wrap = true;
                    break;
                }
                case 3: {
                    --col;
                    direction = 1;
                    wrap = true;
                    break;
                }
                case 6: {
                    --col;
                    direction = 1;
                    break;
                }
                case 7: {
                    ++col;
                    direction = 2;
                    break;
                }
                case 8: {
                    direction = 3;
                    --row;
                    break;
                }
                case 9: {
                    direction = 4;
                    ++row;
                    break;
                }
                case 10: {
                    int firstRow = this.getFirstVisibleRow();
                    if (firstRow >= 0) {
                        if (firstRow == row && (firstRow -= this.getVisibleRowCount()) < 0) {
                            firstRow = 0;
                        }
                    } else {
                        firstRow = row;
                    }
                    row = firstRow;
                    direction = 4;
                    break;
                }
                case 11: {
                    int lastRow = this.getLastVisibleRow();
                    if (lastRow >= 0) {
                        if (lastRow == row && (lastRow += this.getVisibleRowCount()) >= this.getRowCount()) {
                            lastRow = this.getRowCount() - 1;
                        }
                    } else {
                        lastRow = row;
                    }
                    row = lastRow;
                    direction = 3;
                    break;
                }
                case 12: {
                    row = 0;
                    direction = 4;
                    break;
                }
                case 13: {
                    row = this.getRowCount() - 1;
                    direction = 3;
                    break;
                }
                case 14: {
                    col = minCol;
                    direction = 2;
                    break;
                }
                case 15: {
                    col = maxCol;
                    direction = 1;
                }
            }
        }
        int initalRow = row;
        int initalCol = col;
        int i = 0;
        while (!(col >= minCol && col <= maxCol && this.isCellEditable(row, col) || ++i > 100)) {
            switch (direction) {
                case 2: {
                    if (col < maxCol) {
                        ++col;
                        break;
                    }
                    col = minCol;
                    if (row + 1 < rowCount) {
                        ++row;
                        break;
                    }
                    if (!wrap) {
                        return;
                    }
                    row = 0;
                    break;
                }
                case 1: {
                    if (col > minCol) {
                        --col;
                        break;
                    }
                    col = maxCol;
                    if (row - 1 >= 0) {
                        --row;
                        break;
                    }
                    if (!wrap) {
                        return;
                    }
                    row = rowCount - 1;
                    break;
                }
                case 3: {
                    if (row > 0) {
                        --row;
                        break;
                    }
                    if (!wrap) {
                        return;
                    }
                    row = rowCount - 1;
                    break;
                }
                case 4: {
                    if (row + 1 < rowCount) {
                        ++row;
                        break;
                    }
                    if (!wrap) {
                        return;
                    }
                    row = 0;
                }
            }
            if (initalRow != row || initalCol != col) continue;
            row = 0;
            break;
        }
        if (row < 0) {
            row = 0;
        } else if (row >= rowCount) {
            row = rowCount - 1;
        }
        if (!this.isCellEditable(row, col)) {
            return;
        }
        this.selectCell(row, col);
    }

    protected boolean fireCommand(int command) {
        if (this.listenerSupport != null && this.listenerSupport.containsListeners(TreeTableListener.class)) {
            TreeTableEvent e = null;
            Iterator it = this.listenerSupport.getListenerIterator(TreeTableListener.class);
            while (it.hasNext()) {
                if (e == null) {
                    e = new TreeTableEvent(this, 1);
                    e.setCommand(command);
                }
                ((TreeTableListener)it.next()).processCommand(e);
                if (!e.isConsumed()) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void addTreeTableListener(TreeTableListener listener) {
        if (this.listenerSupport == null) {
            this.listenerSupport = new ListenerSupport();
        }
        this.listenerSupport.addListener(TreeTableListener.class, (EventListener)listener);
    }

    public synchronized void addWeakTreeTableListener(TreeTableListener listener) {
        if (this.listenerSupport == null) {
            this.listenerSupport = new ListenerSupport();
        }
        this.listenerSupport.addWeakListener(TreeTableListener.class, (EventListener)listener);
    }

    public synchronized void removeTreeTableListener(TreeTableListener listener) {
        if (this.listenerSupport != null) {
            this.listenerSupport.removeListener(TreeTableListener.class, (EventListener)listener);
        }
    }

    private Point convertTableToTreePoint(Point tablePoint) {
        int width = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (tablePoint.x - (width += this.getColumnModel().getColumn(i).getWidth()) >= 0 || i != this.treeCol) continue;
            int treeXPos = this.getColumnModel().getColumn(i).getWidth() - width + tablePoint.x;
            return new Point(treeXPos, tablePoint.y);
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.forwardMouseEventToTree(me);
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    private void forwardMouseEventToTree(MouseEvent me) {
        int xPosition = me.getPoint().x;
        int width = 0;
        int col = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (xPosition - (width += this.getColumnModel().getColumn(i).getWidth()) >= 0) continue;
            col = i;
            break;
        }
        if (col == this.treeCol && me.getButton() != 1) {
            MouseEvent newME = new MouseEvent(this.tree, me.getID(), me.getWhen(), me.getModifiers(), xPosition - width, me.getY(), me.getClickCount(), me.isPopupTrigger());
            this.tree.dispatchEvent(newME);
        }
    }

    public static Object createDescriptionCellValue(String text) {
        String summary;
        if (text != null && !text.equals(summary = TextUtil.extractSummary((String)text))) {
            text = text.substring(summary.length());
            text = text.trim();
            String[] a = new String[]{summary, text};
            return a;
        }
        return text;
    }

    private class TTModelListener
    implements TreeTableModelListener {
        private int[] selectedRows = null;

        private TTModelListener() {
        }

        @Override
        public void beforeChanges(int tableEventType) {
            if (tableEventType == 0 && this.selectedRows == null) {
                this.selectedRows = JTreeTable.this.getSelectedRows();
            }
        }

        @Override
        public void afterChanges(int tableEventType) {
            JTreeTable.this.sizeRowsToFit();
            JTreeTable.this.sizeColumnsToFit();
            if (tableEventType == -99) {
                return;
            }
            if (this.selectedRows != null) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    JTreeTable.this.changeSelection(this.selectedRows[i], JTreeTable.this.currentCol, false, true);
                }
                this.selectedRows = null;
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            JTreeTable.this.updateUI();
            TreePath path = e.getTreePath();
            TreeTableNode node = (TreeTableNode)path.getLastPathComponent();
            JTreeTable.this.selectNode(node);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            TreeTableNode node;
            TreePath path = e.getTreePath();
            int row = JTreeTable.this.tree.getRowForPath(path) - 1;
            JTreeTable.this.updateUI();
            TreePath newPath = JTreeTable.this.tree.getPathForRow(row);
            TreeTableNode treeTableNode = node = newPath == null ? null : (TreeTableNode)newPath.getLastPathComponent();
            if (node != null) {
                JTreeTable.this.selectNode(node);
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }
    }

    private class CommandAction
    extends AbstractAction {
        int command;

        public CommandAction(String actionId, int command) {
            super(actionId);
            this.command = command;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTreeTable.this.processCommand(this.command);
        }
    }
}

