/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.treetable;

import java.io.Serializable;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openbp.swing.components.treetable.JTreeTable;
import org.openbp.swing.components.treetable.TreeTableModel;
import org.openbp.swing.components.treetable.TreeTableModelListener;
import org.openbp.swing.components.treetable.TreeTableNode;

public class SimpleTreeTableModel
extends AbstractTableModel
implements TreeTableModel,
Serializable {
    protected TreeTableNode root;
    protected JTreeTable treeTable;
    protected String[] columnHeader;

    public SimpleTreeTableModel(TreeTableNode rootNode) {
        this(rootNode, null);
    }

    public SimpleTreeTableModel(TreeTableNode rootNode, JTreeTable treeTable) {
        this.root = rootNode;
        this.addTreeModelListener(new SimpleTreeTableModelListener());
        if (treeTable != null) {
            this.setTreeTable(treeTable);
        }
    }

    @Override
    public void setTreeTable(JTreeTable treeTable) {
        this.treeTable = treeTable;
        treeTable.getTree().addTreeExpansionListener(new TreeTableExpansionListener());
    }

    public void setColumnHeader(String[] columnHeader) {
        this.columnHeader = columnHeader;
    }

    @Override
    public int getRowCount() {
        if (this.treeTable == null || this.treeTable.getTree() == null) {
            return 0;
        }
        return this.treeTable.getTree().getRowCount();
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return TreeTableModel.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return TreeTableModel.class.isAssignableFrom(this.getColumnClass(column));
    }

    public void setValueAt(Object aValue, Object node, int column) {
        throw new IllegalStateException("This method is not implemented. Please overwrite this one.");
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.treeTable == null) {
            return null;
        }
        TreePath path = this.treeTable.getTree().getPathForRow(rowIndex);
        if (path == null) {
            return null;
        }
        TreeTableNode node = (TreeTableNode)path.getLastPathComponent();
        return node.getColumnValue(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.columnHeader == null ? 0 : this.columnHeader.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.columnHeader == null) {
            return super.getColumnName(columnIndex);
        }
        if (this.columnHeader.length < columnIndex) {
            return super.getColumnName(columnIndex);
        }
        return this.columnHeader[columnIndex];
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    public void setRoot(TreeTableNode root) {
        TreeTableNode oldRoot = this.root;
        this.root = root;
        if (root == null && oldRoot != null) {
            this.fireTreeStructureChanged(this, null);
        } else {
            this.fireNodeStructureChanged(root);
        }
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof TreeTableNode) {
            return ((TreeTableNode)parent).getChildCount();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof TreeTableNode) {
            return ((TreeTableNode)node).isLeaf();
        }
        return false;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof TreeTableNode) {
            TreeNode child = ((TreeTableNode)parent).getChildAt(index);
            return child;
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof TreeTableNode && child instanceof TreeTableNode) {
            return ((TreeTableNode)parent).getIndex((TreeTableNode)child);
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public boolean isCellSelectable(int row, int column) {
        return this.treeTable != null && column == this.treeTable.getTreeCol();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public TreeNode[] getPathToRoot(TreeNode aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = aNode == this.root ? new TreeNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }

    public void fireNodeStructureChanged(TreeNode node) {
        if (node != null) {
            this.fireTreeStructureChanged(node, this.getPathToRoot(node), null, null);
        }
    }

    public void fireNodeInserted(TreeNode parent) {
        if (parent != null) {
            this.fireTreeNodesInserted(parent, this.getPathToRoot(parent), null, null);
        }
    }

    public void fireNodeRemoved(TreeNode parent) {
        if (parent != null) {
            this.fireTreeNodesRemoved(parent, this.getPathToRoot(parent), null, null);
        }
    }

    public void fireNodeChanged(TreeNode node) {
        if (node != null) {
            this.fireTreeNodesChanged(node, this.getPathToRoot(node), null, null);
        }
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            if (listeners[i + 1] instanceof TreeTableModelListener) {
                ((TreeTableModelListener)listeners[i + 1]).beforeChanges(0);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            if (listeners[i + 1] instanceof TreeTableModelListener) {
                ((TreeTableModelListener)listeners[i + 1]).beforeChanges(1);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            if (listeners[i + 1] instanceof TreeTableModelListener) {
                ((TreeTableModelListener)listeners[i + 1]).beforeChanges(-1);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            try {
                ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void fireTreeStructureChanged(Object source, TreePath path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path);
            }
            if (listeners[i + 1] instanceof TreeTableModelListener) {
                ((TreeTableModelListener)listeners[i + 1]).beforeChanges(-99);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    public void fireTableChangesCompleted(int tableEventType) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class || !(listeners[i + 1] instanceof TreeTableModelListener)) continue;
            ((TreeTableModelListener)listeners[i + 1]).afterChanges(tableEventType);
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    protected void delayedFireTableDataChanged(int tableEventType) {
        SwingUtilities.invokeLater(new DataChangeRunnable(tableEventType));
    }

    class TreeTableExpansionListener
    implements TreeExpansionListener {
        TreeTableExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            SimpleTreeTableModel.this.fireTableDataChanged();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            SimpleTreeTableModel.this.fireTableDataChanged();
        }
    }

    class SimpleTreeTableModelListener
    implements TreeModelListener {
        SimpleTreeTableModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            SimpleTreeTableModel.this.delayedFireTableDataChanged(0);
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            SimpleTreeTableModel.this.delayedFireTableDataChanged(1);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            SimpleTreeTableModel.this.delayedFireTableDataChanged(-1);
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            SimpleTreeTableModel.this.delayedFireTableDataChanged(-99);
        }
    }

    private class DataChangeRunnable
    implements Runnable {
        private int tableEventType;

        private DataChangeRunnable(int tableEventType) {
            this.tableEventType = tableEventType;
        }

        @Override
        public void run() {
            if (SimpleTreeTableModel.this.treeTable == null) {
                return;
            }
            SimpleTreeTableModel.this.fireTableStructureChanged();
            SimpleTreeTableModel.this.fireTableChangesCompleted(this.tableEventType);
        }
    }
}

