/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.treetable;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.openbp.swing.components.treetable.JTreeTable;
import org.openbp.swing.components.treetable.TreeTableModel;
import org.openbp.swing.components.treetable.TreeTableNode;

public class TreeTableCellEditor
extends DefaultCellEditor {
    protected JTreeTable treeTable;

    public TreeTableCellEditor(JTreeTable treeTable) {
        super(new TreeTableTextField());
        this.treeTable = treeTable;
        treeTable.setCellEditor(this);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        if (component instanceof TreeTableTextField && value instanceof TreeTableNode) {
            ((TreeTableTextField)component).setText(((TreeTableNode)value).getNodeText());
            return null;
        }
        JTree tree = this.treeTable.getTree();
        Rectangle bounds = tree.getRowBounds(row);
        int offset = bounds.x;
        TreeCellRenderer tcr = tree.getCellRenderer();
        if (tcr instanceof DefaultTreeCellRenderer) {
            Object node = tree.getPathForRow(row).getLastPathComponent();
            Icon icon = tree.getModel().isLeaf(node) ? ((DefaultTreeCellRenderer)tcr).getLeafIcon() : (tree.isExpanded(row) ? ((DefaultTreeCellRenderer)tcr).getOpenIcon() : ((DefaultTreeCellRenderer)tcr).getClosedIcon());
            if (icon != null) {
                offset += ((DefaultTreeCellRenderer)tcr).getIconTextGap() + icon.getIconWidth();
            }
        }
        ((TreeTableTextField)this.getComponent()).offset = offset;
        return component;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            JTree tree = this.treeTable.getTree();
            MouseEvent me = (MouseEvent)e;
            int clickedRow = -1;
            int treeColumn = -1;
            for (int i = 0; i < this.treeTable.getColumnCount(); ++i) {
                if (this.treeTable.getColumnClass(i) != TreeTableModel.class) continue;
                clickedRow = tree.getRowForLocation(me.getX() - this.treeTable.getCellRect((int)0, (int)i, (boolean)true).x, me.getY());
                treeColumn = i;
                break;
            }
            if (treeColumn != -1) {
                MouseEvent newME = new MouseEvent(tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger());
                tree.dispatchEvent(newME);
            } else {
                int[] selectedRow = tree.getSelectionRows();
                if (selectedRow != null && selectedRow.length == 1 && selectedRow[0] == clickedRow) {
                    return true;
                }
                this.treeTable.selectCell(clickedRow, treeColumn);
            }
        }
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    static class TreeTableTextField
    extends JTextField {
        public int offset;

        TreeTableTextField() {
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            int newX = Math.max(x, this.offset);
            super.setBounds(newX, y, w - (newX - x), h);
        }
    }
}

