/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.treetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.openbp.swing.components.treetable.DefaultTreeCellRenderer;
import org.openbp.swing.components.treetable.JTreeTable;
import org.openbp.swing.components.treetable.TreeTableModel;

public class TreeTableCellRenderer
extends JTree
implements TableCellRenderer,
TreeExpansionListener {
    private int visibleRow;
    protected JTreeTable treeTable;
    private Color selectionForeground;
    private Color selectionBackground;
    private Color foreground;
    private Color background;

    public TreeTableCellRenderer(JTreeTable treeTable, TreeTableModel model) {
        super(model);
        this.treeTable = treeTable;
        this.setRowHeight(0);
        this.setCellRenderer(new DefaultTreeCellRenderer(treeTable));
        this.addTreeExpansionListener(this);
        this.putClientProperty("JTree.lineStyle", "None");
        this.setDefaultColors();
    }

    public void setCellBackground(Color background) {
        this.background = background == null ? UIManager.getColor("Table.background") : background;
    }

    public void setCellForeground(Color foreground) {
        this.foreground = foreground == null ? UIManager.getColor("Table.foreground") : foreground;
    }

    public void setCellSelectionBackground(Color selectionBackground) {
        this.selectionBackground = selectionBackground == null ? UIManager.getColor("Table.selectionBackground") : selectionBackground;
    }

    public void setCellSelectionForeground(Color selectionForeground) {
        this.selectionForeground = selectionForeground == null ? UIManager.getColor("Table.selectionForeground") : selectionForeground;
    }

    public void setDefaultColors() {
        this.setCellBackground(null);
        this.setCellForeground(null);
        this.setCellSelectionBackground(null);
        this.setCellSelectionForeground(null);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.treeTable != null) {
            this.treeTable.sizeRowsToFit();
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, 0, w, this.treeTable.getHeight());
    }

    @Override
    public void paint(Graphics g) {
        int shift = 0;
        for (int i = 0; i < this.visibleRow; ++i) {
            shift += this.treeTable.getRowHeight(i);
        }
        g.translate(0, -shift);
        super.paint(g);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            if (this.treeTable.getRowSelectionAllowed()) {
                this.setColor(this.selectionForeground, this.selectionBackground);
            } else {
                this.setColor(this.foreground, this.background);
            }
        } else if (hasFocus) {
            this.setColor(this.selectionForeground, this.selectionBackground);
        } else {
            this.setColor(this.foreground, this.background);
        }
        this.visibleRow = row;
        return this;
    }

    protected void setColor(Color foreground, Color background) {
        TreeCellRenderer tcr = this.getCellRenderer();
        if (tcr instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
            dtcr.setForeground(foreground);
            dtcr.setBackground(background);
            dtcr.setBackgroundSelectionColor(background);
            dtcr.setBackgroundNonSelectionColor(background);
        }
        this.setForeground(foreground);
        this.setBackground(background);
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.treeTable.sizeRowsToFit();
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.treeTable.sizeRowsToFit();
    }
}

