/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.treetable.resize;

import org.openbp.swing.components.treetable.JTreeTable;
import org.openbp.swing.components.treetable.resize.ColumnSizeConstraint;

public class FullVisibleConstraint
extends ColumnSizeConstraint {
    private boolean[] visible;

    public FullVisibleConstraint(boolean[] visible) {
        this.visible = visible;
    }

    @Override
    public void calculateColumnSizes(JTreeTable treetable) {
        super.calculateColumnSizes(treetable);
        int width = treetable.getWidth();
        int parts = 0;
        for (int i = 0; i < treetable.getColumnCount(); ++i) {
            if (i < this.visible.length && this.visible[i]) {
                width -= this.getPreferredWidthOfColumn(i);
                continue;
            }
            ++parts;
        }
        int partSize = width / parts;
        for (int i = 0; i < treetable.getColumnCount(); ++i) {
            if (i < this.visible.length && this.visible[i]) continue;
            this.setColumnWidth(2, i, partSize);
        }
    }
}

