/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.treetable.resize;

import org.openbp.swing.components.treetable.JTreeTable;
import org.openbp.swing.components.treetable.resize.ColumnSizeConstraint;

public class RatioConstraint
extends ColumnSizeConstraint {
    private int[] ratio;
    private int parts;
    private boolean isFirstColumnFull;

    public RatioConstraint(boolean firstColumnFull) {
        this.isFirstColumnFull = firstColumnFull;
        this.ratio = new int[0];
    }

    public RatioConstraint(int[] ratio, boolean firstColumnFull) {
        this.isFirstColumnFull = firstColumnFull;
        this.ratio = new int[ratio.length];
        System.arraycopy(ratio, 0, this.ratio, 0, ratio.length);
    }

    @Override
    public void calculateColumnSizes(JTreeTable treetable) {
        super.calculateColumnSizes(treetable);
        this.initRatio(treetable);
        int width = treetable.getWidth();
        int partSize = treetable.getWidth() / this.parts;
        int newParts = this.parts;
        if (this.isFirstColumnFull) {
            partSize = (width -= this.treeColumnMaxWidth) / (this.parts - this.ratio[0]);
            newParts = this.parts - this.ratio[0];
            this.setColumnWidth(2, 0, this.treeColumnMaxWidth);
        } else {
            width -= partSize * this.ratio[0];
            newParts = this.parts - this.ratio[0];
            this.setColumnWidth(2, 0, partSize * this.ratio[0]);
        }
        for (int i = 1; i < treetable.getColumnCount(); ++i) {
            int newSize = partSize * this.ratio[i];
            if (newSize < this.minSizeOfColumns[i]) {
                newSize = this.minSizeOfColumns[i];
                partSize = (width -= newSize) / ((newParts -= this.ratio[i]) == 0 ? 1 : newParts);
            }
            this.setColumnWidth(2, i, newSize);
        }
    }

    private void initRatio(JTreeTable treetable) {
        if (this.parts != 0) {
            return;
        }
        this.parts = 0;
        int[] columns = new int[treetable.getColumnCount()];
        for (int i = 0; i < columns.length; ++i) {
            if (i < this.ratio.length) {
                columns[i] = this.ratio[i] > 0 ? this.ratio[i] : 1;
                this.parts += this.ratio[i];
                continue;
            }
            columns[i] = 1;
            ++this.parts;
        }
        this.ratio = columns;
    }
}

