/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.swing.components.wizard.SequenceManager;
import org.openbp.swing.components.wizard.SequenceManagerImpl;
import org.openbp.swing.components.wizard.Wizard;
import org.openbp.swing.components.wizard.WizardDataModel;
import org.openbp.swing.components.wizard.WizardDataModelImpl;
import org.openbp.swing.components.wizard.WizardEvent;
import org.openbp.swing.components.wizard.WizardLayout;
import org.openbp.swing.components.wizard.WizardListener;
import org.openbp.swing.components.wizard.WizardNavigator;
import org.openbp.swing.components.wizard.WizardPage;
import org.openbp.swing.components.wizard.WizardValidator;

public class WizardImpl
extends JPanel
implements Wizard,
ChangeListener {
    private ResourceCollection wizardResourceCollection;
    private String pageResourcePrefix;
    private ImageIcon defaultWizardImage;
    private ImageIcon defaultBackgroundImage;
    private WizardDataModel dataModel;
    private SequenceManager manager;
    private String resultPageName;
    private List listeners;
    private JPanel deckPanel;
    private Map pages;
    private WizardLayout layout;
    private String lastAdded;
    private WizardNavigator nav;

    public WizardImpl() {
        this(null, null, null);
    }

    public WizardImpl(ResourceCollection wizardResourceCollection) {
        this(wizardResourceCollection, null, null);
    }

    public WizardImpl(ResourceCollection wizardResourceCollection, ImageIcon defaultWizardImage) {
        this(wizardResourceCollection, defaultWizardImage, null);
    }

    public WizardImpl(ResourceCollection wizardResourceCollection, ImageIcon defaultWizardImage, ImageIcon defaultBackgroundImage) {
        this.wizardResourceCollection = wizardResourceCollection;
        this.defaultWizardImage = defaultWizardImage;
        this.defaultBackgroundImage = defaultBackgroundImage;
        this.pages = new HashMap();
        this.setManager(new SequenceManagerImpl());
        this.setDataModel(new WizardDataModelImpl());
        this.setLayout(new BorderLayout());
        this.layout = new WizardLayout();
        this.deckPanel = new JPanel();
        this.deckPanel.setLayout(this.layout);
        this.add("Center", this.deckPanel);
        this.nav = new WizardNavigator(this, wizardResourceCollection);
        this.add("South", this.nav);
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardImpl.this.cancel();
            }
        };
        this.registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke(27, 0), 1);
        this.nav.registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke(27, 0), 1);
        this.setShowHelp(false);
    }

    @Override
    public void addAndLinkPage(String name, Component page) {
        if (this.pages.get(name) == null) {
            if (this.lastAdded == null) {
                this.manager.setFirst(name);
                this.manager.setCurrent(name);
            } else {
                this.manager.setPrevious(name, this.lastAdded);
                this.manager.setNext(this.lastAdded, name);
            }
            this.addPage(name, page);
            this.lastAdded = name;
        }
    }

    @Override
    public void addPage(String name, Component page) {
        if (page instanceof WizardPage) {
            WizardPage wp = (WizardPage)page;
            if (wp.getTitle() == null) {
                wp.setTitle(this.getPageResourceString(name, "title"));
            }
            if (wp.getDescription() == null) {
                wp.setDescription(this.getPageResourceString(name, "description"));
            }
        }
        page.setVisible(true);
        if (this.pages.get(name) == null) {
            this.pages.put(name, page);
            this.deckPanel.add(name, page);
        }
    }

    @Override
    public void removePage(String name) {
        Component page = (Component)this.pages.remove(name);
        if (page != null) {
            this.deckPanel.remove(page);
        }
        this.manager.remove(name);
    }

    @Override
    public Component getPage(String name) {
        return (Component)this.pages.get(name);
    }

    @Override
    public Iterator getPageNames() {
        return this.pages.keySet().iterator();
    }

    @Override
    public Iterator getPages() {
        return this.pages.values().iterator();
    }

    @Override
    public String getResultPageName() {
        return this.resultPageName;
    }

    @Override
    public void setResultPageName(String resultPageName) {
        this.resultPageName = resultPageName;
    }

    @Override
    public void setResultPage(String resultPageName, Component page) {
        this.addPage(resultPageName, page);
        this.setResultPageName(resultPageName);
    }

    @Override
    public void clearPages() {
        this.pages.clear();
        this.manager.clear();
        this.deckPanel.removeAll();
        this.lastAdded = null;
    }

    @Override
    public void displayFirst() {
        if (!this.fireWizardEvent(5)) {
            return;
        }
        this.displayPage(this.manager.getFirst());
    }

    @Override
    public void displayBack() {
        if (!this.fireWizardEvent(4)) {
            return;
        }
        this.displayPage(this.manager.getPrevious());
    }

    @Override
    public void displayNext() {
        if (!this.fireWizardEvent(3)) {
            return;
        }
        this.displayPage(this.manager.getNext());
    }

    @Override
    public void finish() {
        if (!this.fireWizardEvent(2)) {
            return;
        }
        String currentPageName = this.manager.getCurrent();
        if (this.resultPageName != null && !this.resultPageName.equals(currentPageName) && this.getPage(this.resultPageName) != null) {
            this.manager.setPrevious(this.resultPageName, currentPageName);
            this.displayPage(this.resultPageName);
        } else {
            this.hideWizard();
        }
    }

    @Override
    public void cancel() {
        if (!this.fireWizardEvent(1)) {
            return;
        }
        this.hideWizard();
    }

    @Override
    public void close() {
        if (!this.fireWizardEvent(6)) {
            return;
        }
        this.hideWizard();
    }

    @Override
    public boolean canMoveBackward() {
        WizardValidator validator = this.getCurrentValidator();
        if (validator != null && !validator.canMoveBackward()) {
            return false;
        }
        return this.hasBackward();
    }

    @Override
    public boolean hasBackward() {
        return this.manager.getPrevious() != null;
    }

    @Override
    public boolean canMoveForward() {
        WizardValidator validator = this.getCurrentValidator();
        if (validator != null && !validator.canMoveForward()) {
            return false;
        }
        return this.hasForward();
    }

    @Override
    public boolean hasForward() {
        return this.manager.getNext() != null;
    }

    @Override
    public boolean canFinish() {
        WizardValidator validator = this.getCurrentValidator();
        if (validator != null) {
            return validator.canFinish();
        }
        return !this.hasForward();
    }

    @Override
    public boolean canCancel() {
        WizardValidator validator = this.getCurrentValidator();
        return validator == null || validator.canCancel();
    }

    @Override
    public void displayPage(String name) {
        Component c;
        Component page;
        if (name == null) {
            name = this.manager.getCurrent();
        }
        if ((page = this.getPage(name)) == null) {
            return;
        }
        this.manager.setCurrent(name);
        this.layout.show((Container)this.deckPanel, page);
        this.fireWizardEvent(0);
        this.nav.updateNavigator();
        Component focusComponent = page;
        if (page instanceof WizardPage && (c = ((WizardPage)page).getFocusComponent()) != null) {
            focusComponent = c;
        }
        focusComponent.requestFocus();
    }

    @Override
    public void updateNavigator() {
        this.nav.updateNavigator();
    }

    public void hideWizard() {
        Container root = this.getTopLevelAncestor();
        root.setVisible(false);
    }

    @Override
    public void addWizardListener(WizardListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeWizardListener(WizardListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public boolean fireWizardEvent(int eventType) {
        return this.fireWizardEvent(new WizardEvent(this, eventType));
    }

    protected boolean fireWizardEvent(WizardEvent event) {
        Component c = this.getPage(this.manager.getCurrent());
        if (c instanceof WizardListener) {
            ((WizardListener)((Object)c)).handleWizardEvent(event);
            if (event.cancel) {
                return false;
            }
        }
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                WizardListener listener = (WizardListener)this.listeners.get(i);
                listener.handleWizardEvent(event);
                if (!event.cancel) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.nav.updateNavigator();
    }

    @Override
    public WizardDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public void setDataModel(WizardDataModel dataModel) {
        if (this.dataModel != dataModel) {
            if (this.dataModel != null) {
                dataModel.removeChangeListener(this);
            }
            this.dataModel = dataModel;
            dataModel.addChangeListener(this);
        }
    }

    @Override
    public SequenceManager getManager() {
        return this.manager;
    }

    @Override
    public void setManager(SequenceManager manager) {
        this.manager = manager;
    }

    @Override
    public ResourceCollection getResource() {
        return this.wizardResourceCollection;
    }

    @Override
    public void setWizardResource(ResourceCollection wizardResourceCollection) {
        this.wizardResourceCollection = wizardResourceCollection;
    }

    @Override
    public String getPageResourcePrefix() {
        return this.pageResourcePrefix;
    }

    @Override
    public void setPageResourcePrefix(String pageResourcePrefix) {
        this.pageResourcePrefix = pageResourcePrefix;
    }

    @Override
    public void setShowHelp(boolean showHelp) {
        this.nav.setShowHelp(showHelp);
    }

    @Override
    public ImageIcon getDefaultWizardImage() {
        return this.defaultWizardImage;
    }

    @Override
    public void setDefaultWizardImage(ImageIcon defaultWizardImage) {
        this.defaultWizardImage = defaultWizardImage;
    }

    @Override
    public ImageIcon getDefaultBackgroundImage() {
        return this.defaultBackgroundImage;
    }

    @Override
    public void setDefaultBackgroundImage(ImageIcon defaultBackgroundImage) {
        this.defaultBackgroundImage = defaultBackgroundImage;
    }

    @Override
    public String getPageResourceString(String pageName, String suffix) {
        String text = null;
        if (pageName != null) {
            if (this.pageResourcePrefix != null) {
                text = this.wizardResourceCollection.getOptionalString("wizard." + this.pageResourcePrefix + "." + pageName + "." + suffix);
            }
            if (text == null) {
                text = this.wizardResourceCollection.getOptionalString("wizard." + pageName + "." + suffix);
            }
        }
        if (text == null) {
            text = this.wizardResourceCollection.getOptionalString("wizard." + suffix);
        }
        return text;
    }

    private WizardValidator getCurrentValidator() {
        Component c = this.getPage(this.manager.getCurrent());
        if (c instanceof WizardValidator) {
            return (WizardValidator)((Object)c);
        }
        return null;
    }
}

