/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class WizardLayout
implements LayoutManager2,
Serializable {
    private Hashtable comps = new Hashtable();

    public void show(Container parent, String name) {
        Component comp = (Component)this.comps.get(name);
        if (comp != null) {
            this.show(parent, comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Container parent, Component activeComponent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.checkLayout(parent);
            int ncomponents = parent.getComponentCount();
            for (int i = 0; i < ncomponents; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                this.setActive(c, false);
                this.setActive(activeComponent, true);
                parent.validate();
                return;
            }
        }
    }

    @Override
    public void addLayoutComponent(Component c, Object constraints) {
        if (!(constraints instanceof String) && constraints != null) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a string");
        }
        this.addLayoutComponent((String)constraints, c);
    }

    @Override
    public void addLayoutComponent(String name, Component c) {
        if (name == null) {
            throw new IllegalArgumentException("Component must have a name");
        }
        if (this.comps.size() > 0) {
            this.setActive(c, false);
        }
        this.comps.put(name, c);
    }

    @Override
    public void removeLayoutComponent(Component c) {
        Enumeration en = this.comps.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (this.comps.get(key) != c) continue;
            this.comps.remove(key);
            return;
        }
    }

    public void clearLayoutComponents() {
        this.comps.clear();
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int w = 0;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getPreferredSize();
            if (d.width > w) {
                w = d.width;
            }
            if (d.height <= h) continue;
            h = d.height;
        }
        return new Dimension(insets.left + insets.right + w, insets.top + insets.bottom + h);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int w = 0;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getMinimumSize();
            if (d.width > w) {
                w = d.width;
            }
            if (d.height <= h) continue;
            h = d.height;
        }
        return new Dimension(insets.left + insets.right + w, insets.top + insets.bottom + h);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        for (int i = 0; i < ncomponents; ++i) {
            Component c = parent.getComponent(i);
            if (!c.isVisible()) continue;
            c.setBounds(insets.left, insets.top, parent.getSize().width - (insets.left + insets.right), parent.getSize().height - (insets.top + insets.bottom));
        }
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    private void setActive(Component c, boolean enabled) {
        c.setVisible(enabled);
        c.setEnabled(enabled);
    }

    private void checkLayout(Container parent) {
        if (parent.getLayout() != this) {
            throw new IllegalArgumentException("wrong parent for CardLayout");
        }
    }
}

