/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.openbp.swing.components.wizard.EdgeBorder;
import org.openbp.swing.components.wizard.SequenceManager;
import org.openbp.swing.components.wizard.Wizard;
import org.openbp.swing.components.wizard.WizardDataModel;
import org.openbp.swing.components.wizard.WizardEvent;
import org.openbp.swing.components.wizard.WizardListener;
import org.openbp.swing.components.wizard.WizardValidator;

public abstract class WizardPage
extends JPanel
implements WizardValidator,
WizardListener {
    private Wizard wizard;
    public boolean canMoveForward;
    public boolean canMoveBackward = true;
    public boolean canFinish;
    public boolean canCancel = true;
    private String title;
    private String description;
    private ImageIcon wizardImage;
    private ImageIcon backgroundImage;
    private JLabel imageLabel;
    private JLabel titleLabel;
    private JTextArea descriptionArea;

    public WizardPage(Wizard wizard) {
        this(wizard, null, null, null, null);
    }

    public WizardPage(Wizard wizard, String title) {
        this(wizard, title, null, null, null);
    }

    public WizardPage(Wizard wizard, String title, String description) {
        this(wizard, title, description, null, null);
    }

    public WizardPage(Wizard wizard, String title, String description, ImageIcon wizardImage) {
        this(wizard, title, description, wizardImage, null);
    }

    public WizardPage(Wizard wizard, String title, String description, ImageIcon wizardImage, ImageIcon backgroundImage) {
        this.wizard = wizard;
        if (wizardImage == null && wizard != null) {
            wizardImage = wizard.getDefaultWizardImage();
        }
        if (backgroundImage == null && wizard != null) {
            backgroundImage = wizard.getDefaultBackgroundImage();
        }
        this.setLayout(new BorderLayout());
        HeaderPanel headerPanel = new HeaderPanel();
        headerPanel.setLayout(new BorderLayout());
        headerPanel.setBorder(new CompoundBorder(new EdgeBorder(5), new EmptyBorder(5, 10, 5, 10)));
        headerPanel.setBackground(Color.WHITE);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BorderLayout());
        titlePanel.setOpaque(false);
        this.titleLabel = new JLabel(title);
        this.titleLabel.setFont(new Font("Helvetica", 0, 20));
        this.titleLabel.setOpaque(false);
        titlePanel.add("West", this.titleLabel);
        if (wizardImage != null) {
            this.imageLabel = new JLabel(wizardImage);
            this.imageLabel.setOpaque(false);
            this.imageLabel.setBorder(new EmptyBorder(10, 0, 0, 0));
            titlePanel.add("East", this.imageLabel);
        }
        this.descriptionArea = new JTextArea(description);
        this.descriptionArea.setFont(this.getFont());
        this.descriptionArea.setBorder(new EmptyBorder(15, 2, 5, 15));
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setOpaque(false);
        this.descriptionArea.setCaretPosition(0);
        this.descriptionArea.setFocusable(false);
        JScrollPane descriptionScroll = new JScrollPane(this.descriptionArea);
        descriptionScroll.getViewport().setOpaque(false);
        descriptionScroll.setBackground(this.getBackground());
        Dimension size = new Dimension(10, 100);
        descriptionScroll.setMinimumSize(size);
        descriptionScroll.setMaximumSize(size);
        descriptionScroll.setPreferredSize(size);
        descriptionScroll.getViewport().setAutoscrolls(false);
        headerPanel.add("North", titlePanel);
        headerPanel.add("Center", descriptionScroll);
        this.add("North", headerPanel);
    }

    public void updateNavigator() {
        if (this.wizard != null) {
            this.wizard.updateNavigator();
        }
    }

    public Component getFocusComponent() {
        return this;
    }

    @Override
    public void handleWizardEvent(WizardEvent event) {
    }

    @Override
    public boolean canMoveForward() {
        return this.canMoveForward;
    }

    @Override
    public boolean canMoveBackward() {
        return this.canMoveBackward;
    }

    @Override
    public boolean canFinish() {
        return this.canFinish;
    }

    @Override
    public boolean canCancel() {
        return this.canCancel;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleLabel.setText(title);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.descriptionArea.setText(description);
        this.descriptionArea.setCaretPosition(0);
    }

    public ImageIcon getWizardImage() {
        return this.wizardImage;
    }

    public void setWizardImage(ImageIcon wizardImage) {
        this.wizardImage = wizardImage;
        this.imageLabel.setIcon(wizardImage);
    }

    public ImageIcon getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(ImageIcon backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public void setWizard(Wizard wizard) {
        this.wizard = wizard;
    }

    public WizardDataModel getDataModel() {
        return this.wizard != null ? this.wizard.getDataModel() : null;
    }

    public SequenceManager getSequenceManager() {
        return this.wizard != null ? this.wizard.getManager() : null;
    }

    private class HeaderPanel
    extends JPanel {
        public HeaderPanel() {
            this.setOpaque(false);
        }

        @Override
        public void paint(Graphics g) {
            ImageIcon bg = WizardPage.this.backgroundImage;
            if (bg == null && WizardPage.this.wizard != null) {
                bg = WizardPage.this.wizard.getDefaultBackgroundImage();
            }
            if (bg != null) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.drawImage(bg.getImage(), 0, 0, this);
            }
            super.paint(g);
        }
    }
}

