/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.draw;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.openbp.swing.draw.RadialGradientPaintContext;

public class RadialGradientPaint
implements Paint {
    protected Point2D center;
    protected Point2D radius;
    protected Color centerColor;
    protected Color backgroundColor;

    public RadialGradientPaint(Point2D center, Color centerColor, Point2D radius, Color backgroundColor) {
        if (radius.distance(0.0, 0.0) <= 0.0) {
            throw new IllegalArgumentException("Radius must be greater than 0.");
        }
        this.center = center;
        this.centerColor = centerColor;
        this.radius = radius;
        this.backgroundColor = backgroundColor;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        Point2D transformedPoint = xform.transform(this.center, null);
        Point2D transformedRadius = xform.deltaTransform(this.radius, null);
        return new RadialGradientPaintContext(transformedPoint, this.centerColor, transformedRadius, this.backgroundColor);
    }

    @Override
    public int getTransparency() {
        int a2;
        int a1 = this.centerColor.getAlpha();
        return (a1 & (a2 = this.backgroundColor.getAlpha())) == 255 ? 1 : 3;
    }
}

