/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.layout.splitter;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.openbp.swing.layout.splitter.SplitterBar;
import org.openbp.swing.layout.splitter.SplitterConstraint;

public class SplitterLayout
implements LayoutManager2,
Serializable {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private int orientation = 0;
    private Map componentsToConstraints = new HashMap();
    private Component[] currentComps;
    private SplitterConstraint[] currentConstraints;
    private int[] currentSizes;

    public SplitterLayout() {
        this(0);
    }

    public SplitterLayout(int orientation) {
        this.setOrientation(orientation);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    @Override
    public final void addLayoutComponent(Component comp, Object constraints) {
        if (comp instanceof SplitterBar) {
            ((SplitterBar)comp).setOrientation(this.orientation);
            return;
        }
        SplitterConstraint sc = null;
        if (constraints instanceof SplitterConstraint) {
            sc = (SplitterConstraint)constraints;
        } else {
            sc = new SplitterConstraint();
            if (constraints instanceof String) {
                String s = (String)constraints;
                if ((s = s.toLowerCase()).indexOf("fill") != -1) {
                    sc.setFiller(true);
                }
            }
        }
        this.componentsToConstraints.put(comp, sc);
    }

    @Override
    public final void addLayoutComponent(String constraint, Component comp) {
        this.addLayoutComponent(comp, constraint);
    }

    @Override
    public final void removeLayoutComponent(Component comp) {
        this.componentsToConstraints.remove(comp);
    }

    @Override
    public final void layoutContainer(Container container) {
        SplitterConstraint sc;
        Dimension d;
        Component c;
        if (!this.initLayoutProcess(container)) {
            return;
        }
        boolean isVertical = this.orientation == 0;
        Insets insets = container.getInsets();
        Dimension dim = container.getSize();
        int spaceInContainer = isVertical ? dim.height - insets.top - insets.bottom : dim.width - insets.left - insets.right;
        int totalCurrentSize = 0;
        int totalPreferredSize = 0;
        int totalMinSize = 0;
        int totalFillerMinSize = 0;
        int totalSplitterSize = 0;
        ArrayList<Integer> fillerIndices = new ArrayList<Integer>(this.currentComps.length / 2 + 1);
        int nFillers = 0;
        for (int i = 0; i < this.currentComps.length; ++i) {
            int size;
            Dimension dp = null;
            c = this.currentComps[i];
            if (!c.isVisible()) continue;
            int n = size = isVertical ? c.getHeight() : c.getWidth();
            if (size == 0) {
                dp = c.getPreferredSize();
                int n2 = size = isVertical ? dp.height : dp.width;
            }
            if (c instanceof SplitterBar) {
                totalSplitterSize += size;
                continue;
            }
            d = c.getMinimumSize();
            int minSize = isVertical ? d.height : d.width;
            sc = this.currentConstraints[i];
            if (sc.isAnyFiller()) {
                fillerIndices.add(new Integer(i));
                ++nFillers;
                totalFillerMinSize += minSize;
                continue;
            }
            totalCurrentSize += size;
            totalMinSize += minSize;
            if (dp == null) {
                dp = c.getPreferredSize();
            }
            if (dp == null) continue;
            totalPreferredSize += isVertical ? dp.height : dp.width;
        }
        boolean USE_CURR_SIZE = false;
        boolean USE_PREF_SIZE = true;
        int USE_MIN_SIZE = 2;
        int mode = 0;
        mode = totalCurrentSize != 0 && totalCurrentSize + totalSplitterSize + totalFillerMinSize <= spaceInContainer ? 0 : (totalPreferredSize + totalSplitterSize + totalFillerMinSize <= spaceInContainer ? 1 : 2);
        int totalFillerSize = spaceInContainer;
        for (int i = 0; i < this.currentComps.length; ++i) {
            int s;
            c = this.currentComps[i];
            if (!c.isVisible()) continue;
            if (c instanceof SplitterBar) {
                d = c.getPreferredSize();
            } else {
                if (this.currentConstraints[i].isAnyFiller()) continue;
                d = mode == 0 ? c.getSize() : (mode == 1 ? c.getPreferredSize() : c.getMinimumSize());
            }
            this.currentSizes[i] = s = isVertical ? d.height : d.width;
            totalFillerSize -= s;
        }
        int remainingSize = totalFillerSize;
        for (int fi = 0; fi < nFillers; ++fi) {
            int maxSize;
            int fillerIndex = (Integer)fillerIndices.get(fi);
            sc = this.currentConstraints[fillerIndex];
            if (!sc.isAnyFiller()) continue;
            d = this.currentComps[fillerIndex].getMinimumSize();
            int minSize = isVertical ? d.height : d.width;
            d = this.currentComps[fillerIndex].getMaximumSize();
            int n = maxSize = isVertical ? d.height : d.width;
            if (maxSize != 0 && maxSize != Integer.MAX_VALUE) {
                int prefSize;
                d = this.currentComps[fillerIndex].getPreferredSize();
                int n3 = prefSize = isVertical ? d.height : d.width;
                if (prefSize > maxSize) {
                    maxSize = prefSize;
                }
            }
            maxSize = 10000;
            int fillerSize = remainingSize / (nFillers - fi);
            if (minSize != 0 && fillerSize < minSize || maxSize != 0 && fillerSize > maxSize) {
                this.currentSizes[fillerIndex] = minSize != 0 && fillerSize < minSize ? minSize : maxSize;
                fillerIndices.remove(fi);
                --nFillers;
                remainingSize = totalFillerSize -= this.currentSizes[fillerIndex];
                fi = -1;
                continue;
            }
            this.currentSizes[fillerIndex] = fillerSize;
            remainingSize -= fillerSize;
        }
        this.adjustComponentPositions(dim, insets);
        this.resetLayoutProcess();
    }

    public void processSplitterDrag(SplitterBar splitter, Point pDelta, boolean updateLayout) {
        Container container = splitter.getParent();
        if (!this.initLayoutProcess(container)) {
            return;
        }
        this.copyCurrentSizes();
        boolean isVertical = this.orientation == 0;
        int delta = isVertical ? pDelta.y : pDelta.x;
        int pos = isVertical ? splitter.getLocation().y : splitter.getLocation().x;
        int splitterSize = isVertical ? splitter.getHeight() : splitter.getWidth();
        boolean moveUpOrLeft = delta < 0;
        int minSizeTotal = this.determineMinimumSize(container, splitter, moveUpOrLeft);
        if (moveUpOrLeft) {
            if (pos + delta < minSizeTotal) {
                delta = minSizeTotal - pos;
            }
        } else {
            int iTotal;
            int n = iTotal = isVertical ? container.getHeight() : container.getWidth();
            if (pos + splitterSize + delta > iTotal - minSizeTotal) {
                delta = iTotal - minSizeTotal - pos - splitterSize;
            }
        }
        if (isVertical) {
            pDelta.y = delta;
        } else {
            pDelta.x = delta;
        }
        if (updateLayout) {
            Dimension d;
            Component c;
            int i;
            int curr;
            for (curr = 0; curr < this.currentComps.length && this.currentComps[curr] != splitter; ++curr) {
            }
            if (delta < 0) {
                delta = -delta;
            }
            int deltaSav = delta;
            int n = i = moveUpOrLeft ? curr - 1 : curr + 1;
            while ((moveUpOrLeft ? i >= 0 : i < this.currentComps.length) && delta > 0) {
                c = this.currentComps[i];
                if (!(c instanceof SplitterBar)) {
                    int minSize;
                    d = c.getMinimumSize();
                    int n2 = minSize = this.orientation == 0 ? d.height : d.width;
                    if (this.currentSizes[i] - delta >= minSize) {
                        int n3 = i;
                        this.currentSizes[n3] = this.currentSizes[n3] - delta;
                        delta = 0;
                    } else {
                        delta -= this.currentSizes[i] - minSize;
                        this.currentSizes[i] = minSize;
                    }
                }
                if (moveUpOrLeft) {
                    --i;
                    continue;
                }
                ++i;
            }
            delta = deltaSav;
            int n4 = i = moveUpOrLeft ? curr + 1 : curr - 1;
            while ((moveUpOrLeft ? i < this.currentComps.length : i >= 0) && delta > 0) {
                c = this.currentComps[i];
                if (!(c instanceof SplitterBar)) {
                    d = c.getMaximumSize();
                    int maxSize = this.orientation == 0 ? d.height : d.width;
                    maxSize = 10000;
                    if (this.currentSizes[i] + delta <= maxSize) {
                        int n5 = i;
                        this.currentSizes[n5] = this.currentSizes[n5] + delta;
                        delta = 0;
                    } else {
                        delta -= maxSize - this.currentSizes[i];
                        this.currentSizes[i] = maxSize;
                    }
                }
                if (moveUpOrLeft) {
                    ++i;
                    continue;
                }
                --i;
            }
            Insets insets = container.getInsets();
            Dimension dim = container.getSize();
            this.adjustComponentPositions(dim, insets);
        }
        this.resetLayoutProcess();
    }

    private void adjustComponentPositions(Dimension dim, Insets insets) {
        int x = insets.left;
        int y = insets.top;
        int width = dim.width - insets.left - insets.right;
        int height = dim.height - insets.top - insets.bottom;
        for (int i = 0; i < this.currentComps.length; ++i) {
            Component c = this.currentComps[i];
            if (!c.isVisible()) continue;
            if (this.orientation == 0) {
                height = this.currentSizes[i];
            } else {
                width = this.currentSizes[i];
            }
            c.setBounds(x, y, width, height);
            if (this.orientation == 0) {
                y += height;
            } else {
                x += width;
            }
            if (!(c instanceof JComponent)) continue;
            ((JComponent)c).validate();
        }
    }

    @Override
    public final Dimension preferredLayoutSize(Container target) {
        return this.determineLayoutSize(target, true);
    }

    @Override
    public final Dimension minimumLayoutSize(Container target) {
        return this.determineLayoutSize(target, false);
    }

    @Override
    public final Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    private int determineMinimumSize(Container target, Component currentComponent, boolean before) {
        Component[] comps = target.getComponents();
        int start = 0;
        int end = comps.length;
        if (currentComponent != null) {
            for (int i = 0; i < comps.length; ++i) {
                if (currentComponent != comps[i]) continue;
                if (before) {
                    end = i;
                    continue;
                }
                start = i + 1;
            }
        }
        int space = 0;
        Insets insets = target.getInsets();
        space = before ? (this.orientation == 0 ? insets.top : insets.left) : (this.orientation == 0 ? insets.bottom : insets.right);
        for (int i = start; i < end; ++i) {
            Component c = comps[i];
            if (!c.isVisible()) continue;
            Dimension d = c instanceof SplitterBar ? c.getPreferredSize() : c.getMinimumSize();
            space += this.orientation == 0 ? d.height : d.width;
        }
        return space;
    }

    private Dimension determineLayoutSize(Container target, boolean preferredSize) {
        Dimension dim = new Dimension(0, 0);
        Component[] comps = target.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component c = comps[i];
            if (!c.isVisible()) continue;
            Dimension d = preferredSize || c instanceof SplitterBar ? c.getPreferredSize() : c.getMinimumSize();
            if (this.orientation == 0) {
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height;
                continue;
            }
            dim.height = Math.max(d.height, dim.height);
            dim.width += d.width;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    private boolean initLayoutProcess(Container container) {
        int i;
        this.currentComps = container.getComponents();
        this.currentConstraints = new SplitterConstraint[this.currentComps.length];
        this.currentSizes = new int[this.currentComps.length];
        boolean foundFiller = false;
        boolean expectSplitter = false;
        for (i = 0; i < this.currentComps.length; ++i) {
            SplitterConstraint sc;
            this.currentConstraints[i] = null;
            Component c = this.currentComps[i];
            if (!c.isVisible()) continue;
            if (c instanceof SplitterBar) {
                ((SplitterBar)c).setOrientation(this.orientation);
                if (!expectSplitter || i == this.currentComps.length - 1) {
                    c.setVisible(false);
                    continue;
                }
                expectSplitter = false;
                continue;
            }
            this.currentConstraints[i] = sc = this.getSplitterConstraint(c);
            sc.setMakeshiftFiller(false);
            if (sc.isFiller()) {
                foundFiller = true;
            }
            expectSplitter = true;
        }
        if (!foundFiller) {
            for (i = 0; i < this.currentComps.length; ++i) {
                Component c = this.currentComps[i];
                if (!c.isVisible() || c instanceof SplitterBar) continue;
                this.currentConstraints[i].setMakeshiftFiller(true);
            }
        }
        return true;
    }

    private void copyCurrentSizes() {
        for (int i = 0; i < this.currentComps.length; ++i) {
            int size = this.orientation == 0 ? this.currentComps[i].getHeight() : this.currentComps[i].getWidth();
            this.currentSizes[i] = size;
        }
    }

    protected SplitterConstraint getSplitterConstraint(Component c) {
        return (SplitterConstraint)this.componentsToConstraints.get(c);
    }

    private void resetLayoutProcess() {
        this.currentComps = null;
        this.currentConstraints = null;
        this.currentSizes = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[");
        sb.append("orientation=");
        sb.append(this.orientation == 0 ? "vertical" : "horizontal");
        sb.append("]");
        return sb.toString();
    }
}

