/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.plaf.sky;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import javax.swing.AbstractButton;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ButtonUI;
import org.openbp.swing.plaf.sky.SkyButtonUI;
import org.openbp.swing.plaf.sky.SkyTheme;
import org.openbp.swing.plaf.sky.SkyUtil;

public class ButtonBorder
extends AbstractBorder {
    private static final BasicStroke LINESTYLE = new BasicStroke(2.0f, 1, 1);
    private static final Insets INSETS = new Insets(4, 12, 4, 12);

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        ButtonUI ui;
        int shadowheight = 0;
        if (c instanceof AbstractButton && (ui = ((AbstractButton)c).getUI()) instanceof SkyButtonUI) {
            shadowheight = ((SkyButtonUI)ui).getShadowDepth();
        }
        String colorName = null;
        colorName = c.isEnabled() ? (c.hasFocus() ? "Button.focusColor" : "Button.enabled_borderColor") : "Button.disabled_borderColor";
        g.setColor(UIManager.getColor(colorName));
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Stroke backup = g2.getStroke();
        g2.setStroke(LINESTYLE);
        g.drawRect(x + 4 - shadowheight + 1, y + 4 - shadowheight + 1, c.getWidth() - 4 - 2, c.getHeight() - 4 - 2);
        g2.setStroke(backup);
        g.setColor(SkyTheme.COLOR_BORDER);
        g.drawRect(x + 4 - shadowheight, y + 4 - shadowheight, c.getWidth() - 4, c.getHeight() - 4);
        SkyUtil.paintRectShadow(g, 4, 4, c.getWidth() - 4, c.getHeight() - 4, shadowheight);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return INSETS;
    }
}

