/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.plaf.sky;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.border.AbstractBorder;
import org.openbp.swing.plaf.sky.SkyTheme;

public class ReverseShadowBorder
extends AbstractBorder {
    private static final Color DARKCOLOR = new Color(0, 0, 0, 120);
    private static final Color LIGHTCOLOR = new Color(255, 255, 255, 100);
    private static final Insets INSETS = new Insets(4, 5, 2, 2);

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Shape clip = g.getClip();
        int smooth = (int)Math.min((double)width, (double)height) / 2;
        if (smooth > 4) {
            smooth = 4;
        }
        Area area = new Area(new Rectangle2D.Double(x, y, width, height));
        area.subtract(new Area(new Rectangle2D.Double(x + smooth, y + smooth, width - 1, height - 1)));
        area.intersect(new Area(clip.getBounds()));
        g.setClip(area);
        g.setColor(DARKCOLOR);
        g.fillRect(x, y, width - 1, height - 1);
        g.setColor(LIGHTCOLOR);
        for (int i = 0; i < smooth; ++i) {
            g.fillRect(x + i, y + i, width - 2 * i, height - 2 * i);
        }
        g.setClip(clip);
        g.setColor(SkyTheme.COLOR_BORDER);
        g.drawRect(x, y, width - 2, height - 2);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return INSETS;
    }
}

