/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.plaf.sky;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import org.openbp.swing.plaf.sky.SkyTheme;

public class SimpleBorder
extends AbstractBorder {
    private Insets insets;
    private int borderWidth;
    private Color color;
    private static final SimpleBorder standardBorder = new SimpleBorder();

    public static SimpleBorder getStandardBorder() {
        return standardBorder;
    }

    public SimpleBorder() {
        this(1, 1, 1, 1);
    }

    public SimpleBorder(Insets insets) {
        this.insets = insets;
        this.borderWidth = 1;
    }

    public SimpleBorder(int top, int left, int bottom, int right) {
        this(new Insets(top, left, bottom, right));
    }

    public int getWidth() {
        return this.borderWidth;
    }

    public void setWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.color != null ? this.color : SkyTheme.COLOR_BORDER);
        if (this.insets.top > 0 && this.insets.left > 0 && this.insets.bottom > 0 && this.insets.right > 0) {
            int n = this.borderWidth;
            while (n-- > 0) {
                g.drawRect(x, y, width - 1, height - 1);
                ++x;
                ++y;
                width -= 2;
                height -= 2;
            }
        } else {
            int n = this.borderWidth;
            while (n-- > 0) {
                int xEnd = x + width;
                int yEnd = y + height;
                if (this.insets.top > 0) {
                    g.drawLine(x, y, xEnd, y);
                }
                if (this.insets.left > 0) {
                    g.drawLine(x, y, x, yEnd);
                }
                if (this.insets.bottom > 0) {
                    g.drawLine(x, yEnd, xEnd, yEnd);
                }
                if (this.insets.right > 0) {
                    g.drawLine(xEnd, y, xEnd, yEnd);
                }
                ++x;
                ++y;
                width -= 2;
                height -= 2;
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }
}

