/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.plaf.sky;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.TransferHandler;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class SkyColorChooserUI
extends ColorChooserUI {
    private static TransferHandler defaultTransferHandler = new ColorTransferHandler();
    private JColorChooser chooser;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel singlePanel = new JPanel(new BorderLayout());
    private JPanel previewPanelHolder;
    private JComponent previewPanel;
    private MouseListener previewMouseListener;
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new SkyColorChooserUI();
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        AbstractColorChooserPanel[] panels = ColorChooserComponentFactory.getDefaultChooserPanels();
        return panels;
    }

    protected void uninstallDefaultChoosers() {
        for (int i = 0; i < this.defaultChoosers.length; ++i) {
            this.chooser.removeChooserPanel(this.defaultChoosers[i]);
        }
    }

    @Override
    public void installUI(JComponent c) {
        this.chooser = (JColorChooser)c;
        super.installUI(c);
        this.installDefaults();
        this.installListeners();
        this.chooser.setLayout(new BorderLayout());
        this.defaultChoosers = this.createDefaultChoosers();
        this.chooser.setChooserPanels(this.defaultChoosers);
        this.previewPanelHolder = new JPanel(new BorderLayout());
        this.chooser.add((Component)this.previewPanelHolder, "South");
        this.previewMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SkyColorChooserUI.this.chooser.getDragEnabled()) {
                    TransferHandler th = SkyColorChooserUI.this.chooser.getTransferHandler();
                    th.exportAsDrag(SkyColorChooserUI.this.chooser, e, 1);
                }
            }
        };
        this.installPreviewPanel();
        this.chooser.applyComponentOrientation(c.getComponentOrientation());
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.chooser.remove(this.tabbedPane);
        this.chooser.remove(this.singlePanel);
        this.chooser.remove(this.previewPanelHolder);
        this.uninstallListeners();
        this.uninstallDefaultChoosers();
        this.uninstallDefaults();
        this.previewPanelHolder.remove(this.previewPanel);
        if (this.previewPanel instanceof UIResource) {
            this.chooser.setPreviewPanel(null);
        }
        this.previewPanelHolder = null;
        this.previewPanel = null;
        this.defaultChoosers = null;
        this.chooser = null;
        this.tabbedPane = null;
    }

    protected void installPreviewPanel() {
        if (this.previewPanel != null) {
            this.previewPanelHolder.remove(this.previewPanel);
            this.previewPanel.removeMouseListener(this.previewMouseListener);
        }
        this.previewPanel = this.chooser.getPreviewPanel();
        if (this.previewPanel == null || this.previewPanel instanceof UIResource) {
            this.previewPanel = ColorChooserComponentFactory.getPreviewPanel();
            this.chooser.setPreviewPanel(this.previewPanel);
        }
        this.previewPanel.setForeground(this.chooser.getColor());
        this.previewPanelHolder.add(this.previewPanel);
        this.previewPanel.addMouseListener(this.previewMouseListener);
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
        TransferHandler th = this.chooser.getTransferHandler();
        if (th == null || th instanceof UIResource) {
            this.chooser.setTransferHandler(defaultTransferHandler);
        }
    }

    protected void uninstallDefaults() {
        if (this.chooser.getTransferHandler() instanceof UIResource) {
            this.chooser.setTransferHandler(null);
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.previewListener = new PreviewListener();
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
        this.previewPanel.removeMouseListener(this.previewMouseListener);
    }

    static class ColorTransferHandler
    extends TransferHandler
    implements UIResource {
        ColorTransferHandler() {
            super("color");
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("chooserPanels")) {
                AbstractColorChooserPanel[] oldPanels = (AbstractColorChooserPanel[])e.getOldValue();
                AbstractColorChooserPanel[] newPanels = (AbstractColorChooserPanel[])e.getNewValue();
                for (int i = 0; i < oldPanels.length; ++i) {
                    Container wrapper = oldPanels[i].getParent();
                    if (wrapper == null) continue;
                    Container parent = wrapper.getParent();
                    if (parent != null) {
                        parent.remove(wrapper);
                    }
                    oldPanels[i].uninstallChooserPanel(SkyColorChooserUI.this.chooser);
                }
                int numNewPanels = newPanels.length;
                if (numNewPanels == 0) {
                    SkyColorChooserUI.this.chooser.remove(SkyColorChooserUI.this.tabbedPane);
                    return;
                }
                if (numNewPanels == 1) {
                    SkyColorChooserUI.this.chooser.remove(SkyColorChooserUI.this.tabbedPane);
                    JPanel centerWrapper = new JPanel(new BorderLayout());
                    centerWrapper.add(newPanels[0]);
                    SkyColorChooserUI.this.singlePanel.add((Component)centerWrapper, "Center");
                    SkyColorChooserUI.this.chooser.add(SkyColorChooserUI.this.singlePanel);
                } else {
                    if (oldPanels.length < 2) {
                        SkyColorChooserUI.this.chooser.remove(SkyColorChooserUI.this.singlePanel);
                        SkyColorChooserUI.this.chooser.add((Component)SkyColorChooserUI.this.tabbedPane, "Center");
                    }
                    for (int i = 0; i < newPanels.length; ++i) {
                        JPanel centerWrapper = new JPanel(new BorderLayout());
                        String name = newPanels[i].getDisplayName();
                        int mnemonic = newPanels[i].getMnemonic();
                        centerWrapper.add(newPanels[i]);
                        SkyColorChooserUI.this.tabbedPane.addTab(name, centerWrapper);
                        if (mnemonic <= 0) continue;
                        SkyColorChooserUI.this.tabbedPane.setMnemonicAt(i, mnemonic);
                        SkyColorChooserUI.this.tabbedPane.setDisplayedMnemonicIndexAt(i, newPanels[i].getDisplayedMnemonicIndex());
                    }
                }
                SkyColorChooserUI.this.chooser.applyComponentOrientation(SkyColorChooserUI.this.chooser.getComponentOrientation());
                for (int i = 0; i < newPanels.length; ++i) {
                    newPanels[i].installChooserPanel(SkyColorChooserUI.this.chooser);
                }
            }
            if (e.getPropertyName().equals("previewPanel") && e.getNewValue() != SkyColorChooserUI.this.previewPanel) {
                SkyColorChooserUI.this.installPreviewPanel();
            }
            if (e.getPropertyName().equals("componentOrientation")) {
                ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                JColorChooser cc = (JColorChooser)e.getSource();
                if (o != (ComponentOrientation)e.getOldValue()) {
                    cc.applyComponentOrientation(o);
                    cc.updateUI();
                }
            }
        }
    }

    class PreviewListener
    implements ChangeListener {
        PreviewListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ColorSelectionModel model = (ColorSelectionModel)e.getSource();
            if (SkyColorChooserUI.this.previewPanel != null) {
                SkyColorChooserUI.this.previewPanel.setForeground(model.getSelectedColor());
                SkyColorChooserUI.this.previewPanel.repaint();
            }
        }
    }
}

