/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.plaf.sky;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.metal.MetalComboBoxUI;
import org.openbp.swing.plaf.sky.SimpleBorder;
import org.openbp.swing.plaf.sky.SkyTheme;

public class SkyComboBoxUI
extends MetalComboBoxUI
implements SkyTheme {
    public static ComponentUI createUI(JComponent c) {
        return new SkyComboBoxUI();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        ComboBoxEditor editor = super.createEditor();
        Component c = editor.getEditorComponent();
        if (c instanceof JComponent) {
            ((JComponent)c).setBorder(new EditorBorder());
        }
        return editor;
    }

    @Override
    protected JButton createArrowButton() {
        ComboBoxButton button = new ComboBoxButton(this.comboBox, new ComboBoxIcon(), this.comboBox.isEditable(), this.currentValuePane);
        button.setBorder(new SimpleBorder(1, 1, 1, 4));
        return button;
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener() {
        return new SkyPropertyChangeListener();
    }

    public class ComboBoxButton
    extends JButton {
        protected JComboBox comboBox;
        protected CellRendererPane rendererPane;
        protected Icon comboIcon;
        protected boolean iconOnly = false;

        ComboBoxButton() {
            DefaultButtonModel model = new DefaultButtonModel(){

                @Override
                public void setArmed(boolean armed) {
                    super.setArmed(this.isPressed() ? true : armed);
                }
            };
            this.setModel(model);
            this.setBackground(UIManager.getColor("ComboBox.background"));
            this.setForeground(UIManager.getColor("ComboBox.foreground"));
            this.setMargin(new Insets(0, 0, 0, 0));
        }

        public ComboBoxButton(JComboBox cb, Icon i, CellRendererPane pane) {
            this();
            this.comboBox = cb;
            this.comboIcon = i;
            this.rendererPane = pane;
            this.setEnabled(this.comboBox.isEnabled());
        }

        public ComboBoxButton(JComboBox cb, Icon i, boolean onlyIcon, CellRendererPane pane) {
            this(cb, i, pane);
            this.iconOnly = onlyIcon;
        }

        public final JComboBox getComboBox() {
            return this.comboBox;
        }

        public final void setComboBox(JComboBox cb) {
            this.comboBox = cb;
        }

        public final Icon getComboIcon() {
            return this.comboIcon;
        }

        public final void setComboIcon(Icon i) {
            this.comboIcon = i;
        }

        public final boolean isIconOnly() {
            return this.iconOnly;
        }

        public final void setIconOnly(boolean isIconOnly) {
            this.iconOnly = isIconOnly;
        }

        @Override
        public void paintComponent(Graphics g) {
            int iconLeft;
            boolean leftToRight = this.comboBox.getComponentOrientation().isLeftToRight();
            Insets insets = this.getInsets();
            int width = this.getWidth() - (insets.left + insets.right);
            int height = this.getHeight() - (insets.top + insets.bottom);
            if (height <= 0 || width <= 0) {
                return;
            }
            int left = insets.left;
            int top = insets.top;
            int right = left + (width - 1);
            int bottom = top + (height - 1);
            int iconWidth = 0;
            int n = iconLeft = leftToRight ? right : left;
            if (this.comboIcon != null) {
                iconWidth = this.comboIcon.getIconWidth();
                int iconHeight = this.comboIcon.getIconHeight();
                int iconTop = 0;
                if (this.iconOnly) {
                    iconLeft = this.getWidth() / 2 - iconWidth / 2;
                    iconTop = this.getHeight() / 2 - iconHeight / 2;
                } else {
                    iconLeft = leftToRight ? left + (width - 1) - iconWidth : left;
                    iconTop = top + (bottom - top) / 2 - iconHeight / 2;
                }
                g.setColor(this.comboBox.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.comboIcon.paintIcon(this, g, iconLeft, iconTop);
            }
            if (!this.iconOnly && this.comboBox != null) {
                boolean shouldValidate;
                ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
                boolean renderPressed = this.getModel().isPressed();
                Component c = renderer.getListCellRendererComponent(SkyComboBoxUI.this.listBox, this.comboBox.getSelectedItem(), -1, renderPressed, false);
                c.setFont(this.rendererPane.getFont());
                c.setForeground(this.comboBox.getForeground());
                c.setBackground(this.comboBox.getBackground());
                int cWidth = width - (insets.right + iconWidth);
                boolean bl = shouldValidate = c instanceof JPanel;
                if (leftToRight) {
                    this.rendererPane.paintComponent(g, c, this, left, top, cWidth, height, shouldValidate);
                } else {
                    this.rendererPane.paintComponent(g, c, this, left + iconWidth, top, cWidth, height, shouldValidate);
                }
            }
        }
    }

    public class SkyPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public SkyPropertyChangeListener() {
            super(SkyComboBoxUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
        }
    }

    public class ComboBoxIcon
    implements Icon,
    Serializable {
        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JComponent component = (JComponent)c;
            int iconWidth = this.getIconWidth();
            g.translate(x, y);
            g.setColor(component.isEnabled() ? SkyTheme.COLOR_BACKGROUND_DARK_DARK : SkyTheme.COLOR_BACKGROUND_DARK);
            g.drawLine(0, 0, iconWidth - 1, 0);
            g.drawLine(1, 1, 1 + (iconWidth - 3), 1);
            g.drawLine(2, 2, 2 + (iconWidth - 5), 2);
            g.drawLine(3, 3, 3 + (iconWidth - 7), 3);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 4;
        }
    }

    class EditorBorder
    extends AbstractBorder {
        private Insets insets = new Insets(1, 1, 1, 0);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(SkyTheme.COLOR_BORDER);
            g.drawLine(x, y, x + width - 1, y);
            g.drawLine(x, y, x, y + height - 1);
            g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }
    }
}

