/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.plaf.sky;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import org.openbp.swing.plaf.sky.SkyTheme;

public class SkyTabbedPaneUI
extends MetalTabbedPaneUI {
    private static final BasicStroke LINESTYLE = new BasicStroke(2.5f, 1, 1);

    public static ComponentUI createUI(JComponent c) {
        return new SkyTabbedPaneUI();
    }

    @Override
    protected void paintTopTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int currentRun = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        boolean leftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
        int bottom = h - 1;
        int right = w - 1;
        if (this.shouldFillGap(currentRun, tabIndex, x, y)) {
            g.translate(x, y);
            if (leftToRight) {
                g.setColor(this.getColorForGap(currentRun, x, y + 1));
                g.fillRect(1, 0, 5, 3);
                g.fillRect(1, 3, 2, 2);
            } else {
                g.setColor(this.getColorForGap(currentRun, x + w - 1, y + 1));
                g.fillRect(right - 5, 0, 5, 3);
                g.fillRect(right - 2, 3, 2, 2);
            }
            g.translate(-x, -y);
        }
        g.translate(x, y);
        g.setColor(SkyTheme.COLOR_BORDER);
        g.drawRect(0, 0, right, bottom);
        g.translate(-x, -y);
    }

    @Override
    protected void paintLeftTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int currentRun = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        boolean leftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
        int bottom = h - 1;
        int right = w - 1;
        if (this.shouldFillGap(currentRun, tabIndex, x, y)) {
            g.translate(x, y);
            if (leftToRight) {
                g.setColor(this.getColorForGap(currentRun, x, y + 1));
                g.fillRect(1, 0, 5, 3);
                g.fillRect(1, 3, 2, 2);
            } else {
                g.setColor(this.getColorForGap(currentRun, x + w - 1, y + 1));
                g.fillRect(right - 5, 0, 5, 3);
                g.fillRect(right - 2, 3, 2, 2);
            }
            g.translate(-x, -y);
        }
        g.translate(x, y);
        g.setColor(SkyTheme.COLOR_BORDER);
        g.drawRect(0, 0, right, bottom);
        g.translate(-x, -y);
    }

    @Override
    protected void paintBottomTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int currentRun = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        boolean leftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
        int bottom = h - 1;
        int right = w - 1;
        if (this.shouldFillGap(currentRun, tabIndex, x, y)) {
            g.translate(x, y);
            if (leftToRight) {
                g.setColor(this.getColorForGap(currentRun, x, y + 1));
                g.fillRect(1, 0, 5, 3);
                g.fillRect(1, 3, 2, 2);
            } else {
                g.setColor(this.getColorForGap(currentRun, x + w - 1, y + 1));
                g.fillRect(right - 5, 0, 5, 3);
                g.fillRect(right - 2, 3, 2, 2);
            }
            g.translate(-x, -y);
        }
        g.translate(x, y);
        g.setColor(SkyTheme.COLOR_BORDER);
        g.drawRect(0, 0, right, bottom);
        g.translate(-x, -y);
    }

    @Override
    protected void paintRightTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int currentRun = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        boolean leftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
        int bottom = h - 1;
        int right = w - 1;
        if (this.shouldFillGap(currentRun, tabIndex, x, y)) {
            g.translate(x, y);
            if (leftToRight) {
                g.setColor(this.getColorForGap(currentRun, x, y + 1));
                g.fillRect(1, 0, 5, 3);
                g.fillRect(1, 3, 2, 2);
            } else {
                g.setColor(this.getColorForGap(currentRun, x + w - 1, y + 1));
                g.fillRect(right - 5, 0, 5, 3);
                g.fillRect(right - 2, 3, 2, 2);
            }
            g.translate(-x, -y);
        }
        g.translate(x, y);
        g.setColor(SkyTheme.COLOR_BORDER);
        g.drawRect(0, 0, right, bottom);
        g.translate(-x, -y);
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (this.tabPane.hasFocus() && isSelected) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            String title = this.tabPane.getTitleAt(tabIndex);
            if (title == null || title.trim().equals("")) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            Stroke backup = g2.getStroke();
            g2.setStroke(LINESTYLE);
            g2.setColor(UIManager.getColor("TabbedPane.focus"));
            g2.drawLine(textRect.x, textRect.y + textRect.height, textRect.x + textRect.width, textRect.y + textRect.height);
            g2.setStroke(backup);
        }
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (!isSelected) {
            g.setColor(UIManager.getColor("TabbedPane.background"));
        } else {
            g.setColor(UIManager.getColor("TabbedPane.selected"));
        }
        g.fillRect(x, y, w, h);
    }
}

