/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.plaf.sky;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.TreePath;

public class SkyTreeUI
extends MetalTreeUI {
    private TreePath expandPathOnMouseUp;

    public static ComponentUI createUI(JComponent c) {
        return new SkyTreeUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tree.addMouseMotionListener(new MouseMotionHandler());
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    @Override
    protected void selectPathForEvent(TreePath path, MouseEvent event) {
        if (!this.isToggleSelectionEvent(event) && !this.isMultiSelectEvent(event) && SwingUtilities.isLeftMouseButton(event) && this.isSingleClickExpansionEvent(event)) {
            this.tree.setSelectionPath(path);
            if (!this.tree.isExpanded(path)) {
                this.expandPathOnMouseUp = path;
            }
            return;
        }
        super.selectPathForEvent(path, event);
    }

    private boolean isSingleClickExpansionEvent(MouseEvent event) {
        return this.tree.getToggleClickCount() == 1 && event.getClickCount() == 1;
    }

    public class MouseMotionHandler
    extends MouseMotionAdapter {
        @Override
        public void mouseDragged(MouseEvent e) {
            SkyTreeUI.this.expandPathOnMouseUp = null;
        }
    }

    public class MouseHandler
    extends BasicTreeUI.MouseHandler {
        public MouseHandler() {
            super(SkyTreeUI.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SkyTreeUI.this.expandPathOnMouseUp != null) {
                SkyTreeUI.this.tree.expandPath(SkyTreeUI.this.expandPathOnMouseUp);
                SkyTreeUI.this.expandPathOnMouseUp = null;
            }
        }
    }
}

