/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.plaf.sky;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class SkyUtil {
    public static final int RADIUS = 4;
    public static final int MAXSHADOWDEPTH = 4;
    public static final int DEFAULTSHADOWDEPTH = 4;
    private static final Color SHADOWCOLOR = new Color(0, 0, 0, 20);
    private static final double MAXSHADOWALPHA = 100.0;
    private static final double MAXLIGHTALPHA = 100.0;
    private static Color[] shadowColorArray;
    private static Color[] lightColorArray;

    public static void paintRoundRectShadow(Graphics g, int x, int y, int width, int height, int radius) {
        SkyUtil.paintRoundRectShadow(g, x, y, width, height, radius, 5);
    }

    public static void paintRoundRectShadow(Graphics g, int x, int y, int width, int height, int radius, int shadowsteps) {
        Shape clip = g.getClip();
        int smooth = (int)Math.min((double)width, (double)height) / 2;
        if (smooth > shadowsteps) {
            smooth = shadowsteps;
        }
        Area area = new Area(new RoundRectangle2D.Double(x, y, width, height, 4.0, 4.0));
        area.subtract(new Area(new RoundRectangle2D.Double(x, y, width - smooth, height - smooth, radius, radius)));
        area.intersect(new Area(clip.getBounds()));
        g.setClip(area);
        g.setColor(SHADOWCOLOR);
        for (int i = 0; i < smooth; ++i) {
            g.fillRoundRect(x + i, y + i, width - 2 * i, height - 2 * i, radius - i < 0 ? 0 : radius - i, radius - i < 0 ? 0 : radius - i);
        }
        g.setClip(clip);
    }

    public static void paintRectShadow(Graphics g, int x, int y, int width, int height) {
        SkyUtil.paintRectShadow(g, x, y, width, height, 5);
    }

    public static void paintRectShadow(Graphics g, int x, int y, int width, int height, int shadowsteps) {
        Shape clip = g.getClip();
        int smooth = (int)Math.min((double)width, (double)height) / 2;
        if (smooth > shadowsteps) {
            smooth = shadowsteps;
        }
        Area area = new Area(new RoundRectangle2D.Double(x, y, width, height, 4.0, 4.0));
        area.subtract(new Area(new Rectangle(x, y, width - smooth, height - smooth)));
        area.intersect(new Area(clip.getBounds()));
        g.setClip(area);
        g.setColor(SHADOWCOLOR);
        for (int i = 0; i < smooth; ++i) {
            g.fillRoundRect(x + i, y + i, width - 2 * i, height - 2 * i, 4 - i < 0 ? 0 : 4 - i, 4 - i < 0 ? 0 : 4 - i);
        }
        g.setClip(clip);
    }

    public static void paint3DRoundRectEffect(Graphics g, int x, int y, int width, int height, int radius) {
        SkyUtil.paint3DRoundRectEffect(g, x, y, width, height, radius, 5);
    }

    public static void paint3DRoundRectEffect(Graphics g, int x, int y, int width, int height, int radius, int depth) {
        if (shadowColorArray == null) {
            SkyUtil.createArrays();
        }
        if (!(g instanceof Graphics2D)) {
            return;
        }
        int smooth = Math.min(width, height) / 2;
        if (smooth > depth) {
            smooth = depth;
        }
        for (int i = 0; i < smooth; ++i) {
            g.setColor(shadowColorArray[(int)(100.0 / (double)smooth * (double)(smooth - i)) - 1]);
            g.drawLine(x + radius + 1, y + height - i, x + width - radius - 1, y + height - i);
            g.drawLine(x + width - i, y + radius + 1, x + width - i, y + height - radius - 1);
            g.drawArc(x + i, y + height - 2 * radius + i, 2 * (radius - i), 2 * (radius - i), -90, -45);
            g.drawArc(x + width - 2 * radius + i, y + height - 2 * radius + i, 2 * (radius - i), 2 * (radius - i), 0, -90);
            g.drawArc(x + width - 2 * radius + i, y + i, 2 * (radius - i), 2 * (radius - i), 45, -45);
            g.setColor(lightColorArray[(int)(100.0 / (double)smooth * (double)i)]);
            g.drawLine(x + radius + 1, y + i, x + width - radius - 1, y + i);
            g.drawLine(x + i, y + radius + 1, x + i, y + height - radius - 1);
            g.drawArc(x + width - 2 * radius + i, y + i, 2 * (radius - i), 2 * (radius - i), 90, -45);
            g.drawArc(x + i, y + i, 2 * (radius - i), 2 * (radius - i), 90, 90);
            g.drawArc(x + i, y + height - 2 * radius + i, 2 * (radius - i), 2 * (radius - i), 180, 45);
        }
    }

    public static void paint3DRectEffect(Graphics graphics, int x, int y, int width, int height) {
        SkyUtil.paint3DRectEffect(graphics, x, y, width, height, 5);
    }

    public static void paint3DRectEffect(Graphics graphics, int x, int y, int width, int height, int depth) {
        if (shadowColorArray == null) {
            SkyUtil.createArrays();
        }
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D g = (Graphics2D)graphics;
        int smooth = (int)Math.min((double)width, (double)height) / 2;
        if (smooth > depth) {
            smooth = depth;
        }
        for (int i = 0; i < smooth; ++i) {
            g.setColor(shadowColorArray[(int)(100.0 / (double)smooth * (double)(smooth - i)) - 1]);
            g.drawLine(x + i + 1, y + height - i, x + width - i - 1, y + height - i);
            g.drawLine(x + width - i, y + i, x + width - i, y + height - i);
            g.setColor(lightColorArray[(int)(100.0 / (double)smooth * (double)i)]);
            g.drawLine(x + i + 1, y + i, x + width - i - 1, y + i);
            g.drawLine(x + i, y + i, x + i, y + height - i);
        }
    }

    private static void createArrays() {
        shadowColorArray = new Color[100];
        lightColorArray = new Color[100];
        for (int i = 0; i < 100; ++i) {
            SkyUtil.shadowColorArray[i] = new Color(0, 0, 0, i);
            SkyUtil.lightColorArray[i] = new Color(255, 255, 255, i);
        }
    }

    public static Icon createGrayIcon(Icon icon) {
        Icon disabledIcon = null;
        if (icon instanceof ImageIcon) {
            disabledIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }
        return disabledIcon != null ? disabledIcon : icon;
    }
}

