/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common;

import java.util.Properties;

public final class CommonUtil {
    private static String javaVersionStr;
    private static int javaVersionInt;

    private CommonUtil() {
    }

    public static boolean equalsNull(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static int compareNull(Object o1, Object o2) {
        Comparable c1 = (Comparable)o1;
        Comparable c2 = (Comparable)o2;
        if (c1 == null) {
            if (c2 == null) {
                return 0;
            }
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        return c1.compareTo(c2);
    }

    public static String toStringNull(Object o) {
        return o != null ? o.toString() : null;
    }

    public static int rnd(float v) {
        return (int)Math.floor(v + 0.5f);
    }

    public static int rnd(double v) {
        return (int)Math.floor(v + 0.5);
    }

    public static String setSystemProperty(String key, String value) {
        String ret;
        if (value != null) {
            ret = System.setProperty(key, value);
        } else {
            ret = System.getProperty(key);
            if (ret != null) {
                Properties props = System.getProperties();
                props.remove(key);
            }
        }
        return ret;
    }

    public static boolean isJava14() {
        return CommonUtil.getJavaVersionInt() >= 140;
    }

    public static String getJavaVersionStr() {
        CommonUtil.determineJavaVersion();
        return javaVersionStr;
    }

    public static int getJavaVersionInt() {
        CommonUtil.determineJavaVersion();
        return javaVersionInt;
    }

    private static void determineJavaVersion() {
        if (javaVersionStr == null) {
            javaVersionStr = System.getProperty("java.version");
            int l = javaVersionStr.length();
            javaVersionInt = (javaVersionStr.charAt(0) - 48) * 100;
            if (l > 2) {
                javaVersionInt += (javaVersionStr.charAt(2) - 48) * 10;
            }
            if (l > 4) {
                javaVersionInt += (javaVersionStr.charAt(4) - 48) * 1;
            }
        }
    }
}

