/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.openbp.common.CollectionUtil;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.MsgFormat;
import org.openbp.common.ReflectException;
import org.openbp.common.logger.LogUtil;

public final class ReflectUtil {
    public static final int CM_PRINT = 1;
    public static final int CM_THROW = 2;

    private ReflectUtil() {
    }

    public static Class findClassInPackageList(String className, List packageList) {
        return ReflectUtil.findClassInPackageList(className, packageList, null);
    }

    public static Class findClassInPackageList(String className, List packageList, ClassLoader cl) {
        if (packageList != null) {
            int n = packageList.size();
            for (int i = 0; i < n; ++i) {
                String pkg = (String)packageList.get(i);
                Class c = ReflectUtil.loadClass(pkg + "." + className, cl);
                if (c == null) continue;
                return c;
            }
        }
        return null;
    }

    public static Class loadClass(String className) {
        return ReflectUtil.loadClass(className, null);
    }

    public static Class loadClass(String className, ClassLoader cl) {
        try {
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            if (cl != null) {
                return cl.loadClass(className);
            }
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    public static Object instantiate(String className, ClassLoader cl, Class type, String displayName) {
        Class cls = ReflectUtil.loadClass(className, cl);
        if (cls == null) {
            throw new ReflectException(MsgFormat.format("The {0} class $1 could not be found in the class path.", displayName, className));
        }
        return ReflectUtil.instantiate(cls, type, displayName);
    }

    public static Object instantiate(Class cls, Class type, String displayName) {
        return ReflectUtil.instantiate(cls, null, type, displayName);
    }

    public static Object instantiate(Class cls, ClassLoader cl, Class type, String displayName) {
        try {
            Object o = cls.newInstance();
            if (type != null && !type.isInstance(o)) {
                throw new ReflectException(MsgFormat.format("The {0} class $1 is not an instance of the interface or class $2.", displayName, ReflectUtil.getPrintableClassName(cls), type.getName()));
            }
            return o;
        }
        catch (InstantiationException e) {
            throw new ReflectException(MsgFormat.format("The {0} class $1 could not be instantiated.", displayName, ReflectUtil.getPrintableClassName(cls)), e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectException(MsgFormat.format("The {0} class $1 could not be instantiated.", displayName, ReflectUtil.getPrintableClassName(cls)), e);
        }
        catch (Throwable t) {
            throw new ReflectException(MsgFormat.format("The {0} class $1 could not be initialized.", displayName, ReflectUtil.getPrintableClassName(cls)), t);
        }
    }

    public static Object instantiate(String className, Class type, String displayName) {
        return ReflectUtil.instantiate(className, null, type, displayName);
    }

    public static Object instantiateByConstructor(Class cls, Class[] argTypes, Object[] args, Class type, String displayName, boolean allowDefaultConstructor) {
        Object instance = null;
        try {
            Constructor constructor = cls.getConstructor(argTypes);
            if (constructor != null) {
                instance = constructor.newInstance(args);
            } else {
                if (!allowDefaultConstructor) {
                    StringBuffer sb = new StringBuffer();
                    int sizeAT = argTypes.length;
                    for (int indexAT = 0; indexAT < sizeAT; ++indexAT) {
                        sb.append(ReflectUtil.getPrintableClassName(argTypes[indexAT]));
                        if (indexAT >= sizeAT - 1) continue;
                        sb.append(", ");
                    }
                    String msg = LogUtil.error(ReflectUtil.class, "Instantiation of {0}({1})failed! ", new String[]{ReflectUtil.getPrintableClassName(cls), sb.toString()});
                    throw new ReflectException(msg);
                }
                instance = cls.newInstance();
            }
        }
        catch (SecurityException e) {
            String msg = LogUtil.error(ReflectUtil.class, e.getMessage(), e);
            throw new ReflectException(msg);
        }
        catch (IllegalArgumentException e) {
            String msg = LogUtil.error(ReflectUtil.class, e.getMessage(), e);
            throw new ReflectException(msg);
        }
        catch (NoSuchMethodException e) {
            String msg = LogUtil.error(ReflectUtil.class, e.getMessage(), e);
            throw new ReflectException(msg);
        }
        catch (InstantiationException e) {
            String msg = LogUtil.error(ReflectUtil.class, e.getMessage(), e);
            throw new ReflectException(msg);
        }
        catch (IllegalAccessException e) {
            String msg = LogUtil.error(ReflectUtil.class, e.getMessage(), e);
            throw new ReflectException(msg);
        }
        catch (InvocationTargetException e) {
            String msg = LogUtil.error(ReflectUtil.class, e.getMessage(), e);
            throw new ReflectException(msg);
        }
        if (type != null && !type.isInstance(instance)) {
            throw new ReflectException(MsgFormat.format("The {0} class $1 is not an instance of the interface or class $2.", displayName, ReflectUtil.getPrintableClassName(cls), type.getName()));
        }
        return instance;
    }

    public static Object callMethod(Object o, String methodName, Class[] argClasses, Object[] argValues, int errorHandlingMode) throws Exception {
        if (o == null) {
            if ((errorHandlingMode & 1) != 0) {
                LogUtil.error(ReflectUtil.class, "Cannot call method '" + methodName + "' on null object");
            }
            if ((errorHandlingMode & 2) != 0) {
                throw new IllegalArgumentException("Cannot call method '" + methodName + "' on null object");
            }
            return null;
        }
        Class<?> cls = o.getClass();
        Method method = null;
        try {
            method = cls.getMethod(methodName, argClasses);
        }
        catch (NoSuchMethodException e) {
            if ((errorHandlingMode & 1) != 0) {
                LogUtil.error(ReflectUtil.class, "Cannot find method '" + methodName + "' in class '" + cls.getName() + "'");
            }
            if ((errorHandlingMode & 2) != 0) {
                throw e;
            }
            return null;
        }
        return ReflectUtil.callMethod(o, method, argValues, errorHandlingMode);
    }

    public static Object callMethod(Object o, Method method, Object[] argValues, int errorHandlingMode) throws Exception {
        Object result;
        Class<?> cls = o.getClass();
        try {
            result = method.invoke(o, argValues);
        }
        catch (IllegalAccessException e) {
            if ((errorHandlingMode & 1) != 0) {
                LogUtil.error(ReflectUtil.class, "Cannot access method '" + method.getName() + "' in class '" + cls.getName() + "'");
            }
            if ((errorHandlingMode & 2) != 0) {
                throw e;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            if ((errorHandlingMode & 1) != 0) {
                LogUtil.error(ReflectUtil.class, "Invalid arguments to method '" + method.getName() + "' in class '" + cls.getName() + "'");
            }
            if ((errorHandlingMode & 2) != 0) {
                throw e;
            }
            return null;
        }
        catch (InvocationTargetException e) {
            if ((errorHandlingMode & 1) != 0) {
                LogUtil.error(ReflectUtil.class, "Exception in method '" + method.getName() + "' in class '" + cls.getName() + "': " + ExceptionUtil.getNestedTrace(e));
            }
            if ((errorHandlingMode & 2) != 0) {
                throw e;
            }
            return null;
        }
        return result;
    }

    public static String getQualifiedMethodSignature(Method method) {
        return method.getDeclaringClass().getName() + '.' + ReflectUtil.getUnqualifiedMethodSignature(method);
    }

    public static String getUnqualifiedMethodSignature(Method method) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getName());
        sb.append('(');
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(ReflectUtil.getPrintableClassName(params[i]));
        }
        sb.append(')');
        return sb.toString();
    }

    public static Method findByQualifiedMethodSignature(String signature) throws NoSuchMethodException, ClassNotFoundException {
        int iOpar = signature.indexOf(40);
        int iCpar = signature.indexOf(41);
        if (iOpar < 0 || iCpar < 0) {
            throw new NoSuchMethodException("Invalid method signature: " + signature);
        }
        String classAndMethodName = signature.substring(0, iOpar);
        String argList = signature.substring(iOpar, iCpar + 1);
        int i = classAndMethodName.lastIndexOf(46);
        String objectClassName = classAndMethodName.substring(0, i);
        Class objectClass = ReflectUtil.loadClass(objectClassName);
        String unqualifiedSignature = classAndMethodName.substring(i + 1) + argList;
        return ReflectUtil.findByUnqualifiedMethodSignature(objectClass, unqualifiedSignature);
    }

    public static Method findByUnqualifiedMethodSignature(Class objectClass, String signature) throws NoSuchMethodException, ClassNotFoundException {
        int iOpar = signature.indexOf(40);
        int iCpar = signature.indexOf(41);
        if (iOpar < 0 || iCpar < 0) {
            throw new NoSuchMethodException("Invalid method signature: " + signature);
        }
        String methodName = signature.substring(0, iOpar);
        String argClassNames = signature.substring(iOpar + 1, iCpar);
        ArrayList<Class> args = new ArrayList<Class>();
        StringTokenizer st = new StringTokenizer(argClassNames, ",");
        while (st.hasMoreTokens()) {
            String argClassName = st.nextToken();
            Class argClass = ReflectUtil.determineClass(argClassName);
            if (argClass == null) {
                throw new ClassNotFoundException("Argument class " + argClassName + " not found.");
            }
            args.add(argClass);
        }
        Class[] argClasses = (Class[])CollectionUtil.toArray(args, Class.class);
        Method m = objectClass.getMethod(methodName, argClasses);
        return m;
    }

    public static String getPrintableClassName(Class cls) {
        if (cls == null) {
            return "null";
        }
        if (cls.isArray()) {
            Class<?> componentClass = cls.getComponentType();
            return ReflectUtil.getPrintableClassName(componentClass) + "[]";
        }
        return cls.getName();
    }

    public static Class determineClass(String stringRepresentation) {
        String array = "[]";
        boolean isArray = stringRepresentation.endsWith(array);
        if (isArray) {
            stringRepresentation = stringRepresentation.substring(0, stringRepresentation.indexOf(array)).trim();
        }
        Class c = null;
        if ("int".equals(stringRepresentation)) {
            c = Integer.TYPE;
        } else if ("long".equals(stringRepresentation)) {
            c = Long.TYPE;
        } else if ("short".equals(stringRepresentation)) {
            c = Short.TYPE;
        } else if ("byte".equals(stringRepresentation)) {
            c = Byte.TYPE;
        } else if ("boolean".equals(stringRepresentation)) {
            c = Boolean.TYPE;
        } else if ("char".equals(stringRepresentation)) {
            c = Character.TYPE;
        } else if ("float".equals(stringRepresentation)) {
            c = Float.TYPE;
        } else if ("double".equals(stringRepresentation)) {
            c = Double.TYPE;
        } else {
            c = ReflectUtil.loadClass(stringRepresentation);
            if (c == null) {
                return null;
            }
        }
        if (isArray) {
            c = Array.newInstance(c, 0).getClass();
        }
        return c;
    }

    public static Method getMethodOrNull(Class cls, String name, Class[] args) {
        try {
            return cls.getMethod(name, args);
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
    }

    public static Field getFieldOrNull(Class cls, String name) {
        try {
            return cls.getField(name);
        }
        catch (NoSuchFieldException nsme) {
            return null;
        }
    }
}

