/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.classloader;

import java.net.MalformedURLException;
import java.net.URL;
import org.openbp.common.classloader.UrlResourceSpec;
import org.openbp.common.net.ByteArrayURLStreamHandler;

public abstract class BinaryResourceSpec
extends UrlResourceSpec {
    public byte[] content;

    public BinaryResourceSpec() {
    }

    public BinaryResourceSpec(URL url) {
        super(url);
    }

    public BinaryResourceSpec(URL url, byte[] content) {
        super(url);
        this.content = content;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    @Override
    public URL toUrl() {
        URL sourceUrl = this.getUrl();
        if (this.content != null) {
            try {
                ByteArrayURLStreamHandler handler = new ByteArrayURLStreamHandler(this.getContent());
                URL ret = new URL(sourceUrl.getProtocol(), sourceUrl.getHost(), sourceUrl.getPort(), sourceUrl.getFile(), handler);
                return ret;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return sourceUrl;
    }
}

