/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.classloader;

import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openbp.common.classloader.PackageList;
import org.openbp.common.classloader.XClassLoaderBase;
import org.openbp.common.string.StringUtil;

public class XClassLoaderConfiguration
implements Cloneable {
    private boolean tryStandardClassLoaderFirst = true;
    private String name;
    private List repositories = new Vector();
    private PackageList standardPackages = new PackageList();
    private PackageList nonStandardPackages = new PackageList();
    private ClassLoader parentClassLoader;
    private boolean loggingEnabled;

    public XClassLoaderConfiguration() {
        this.standardPackages.addPackage("java.*");
        this.standardPackages.addPackage("javax.*");
        this.standardPackages.addPackage("sun.*");
        this.standardPackages.addPackage("com.sun.*");
        this.parentClassLoader = this.getClass().getClassLoader();
    }

    public void printDebug(XClassLoaderBase cl) {
        cl.log("Info", "Class loader configuration:");
        cl.log("Info", "Using standard loaders first: {0}", this.tryStandardClassLoaderFirst ? "true" : "false");
        cl.log("Info", "Parent class loader: {0}", this.parentClassLoader != null ? this.parentClassLoader.toString() : "none");
        this.standardPackages.printDebug("Standard package", cl);
        this.nonStandardPackages.printDebug("Non-standard package", cl);
    }

    public void addStandardPackage(String packageName) {
        this.standardPackages.addPackage(packageName);
    }

    public void addNonStandardPackage(String packageName) {
        this.nonStandardPackages.addPackage(packageName);
    }

    public PackageList getStandardPackages() {
        return this.standardPackages;
    }

    public PackageList getNonStandardPackages() {
        return this.nonStandardPackages;
    }

    public void setTryStandardClassLoaderFirst(boolean tryStandardClassLoaderFirst) {
        this.tryStandardClassLoaderFirst = tryStandardClassLoaderFirst;
    }

    public boolean getTryStandardClassLoaderFirst() {
        return this.tryStandardClassLoaderFirst;
    }

    public void addRepositories(String repositoryList) {
        if (repositoryList != null) {
            StringTokenizer t = new StringTokenizer(repositoryList, File.pathSeparator);
            while (t.hasMoreTokens()) {
                String s = t.nextToken();
                this.addRepository(s);
            }
        }
    }

    public void addRepository(String repository) {
        if (repository != null && !this.repositories.contains(repository = StringUtil.absolutePathName(repository))) {
            this.repositories.add(repository);
        }
    }

    public List getRepositories() {
        return this.repositories;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }
}

