/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.io.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.XMLContext;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.logger.LogUtil;
import org.springframework.core.io.Resource;
import org.w3c.dom.Node;

public final class XMLDriver {
    private Map mappedClasses = new HashMap();
    private XMLContext context;
    private Mapping mapping;
    private ClassLoader loader;
    private String encoding = "UTF-8";
    private boolean prettyPrint;
    private boolean debugMode = false;
    private static XMLDriver singletonInstance;
    private static ClassLoader defaultClassLoader;

    public static synchronized XMLDriver getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new XMLDriver();
        }
        return singletonInstance;
    }

    private XMLDriver() {
        this(defaultClassLoader);
    }

    public XMLDriver(ClassLoader loader) {
        if (loader == null) {
            loader = defaultClassLoader != null ? defaultClassLoader : this.getClass().getClassLoader();
        }
        this.loader = loader;
        this.mapping = new Mapping(loader);
    }

    public static void setDefaultClassLoader(ClassLoader defaultClassLoaderArg) {
        defaultClassLoader = defaultClassLoaderArg;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    private XMLContext getContext() throws MappingException {
        if (this.context == null) {
            this.context = new XMLContext();
            this.context.setProperty("org.exolab.castor.indent", (Object)(this.isPrettyPrint() ? "true" : "false"));
            this.context.setProperty("org.exolab.castor.debug", (Object)"true");
            this.context.addMapping(this.mapping);
        }
        return this.context;
    }

    public void serializeObject(Object o, ObjectOutputStream out) throws IOException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
            this.serialize(o, bos);
            out.writeObject(bos.toByteArray());
        }
        catch (XMLDriverException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void serialize(Object o, String fileName) throws XMLDriverException {
        try {
            this.serialize(o, new FileWriter(fileName));
        }
        catch (IOException e) {
            String s = LogUtil.warn(this.getClass(), "Error writing XML data to file $0.", fileName, e);
            throw new XMLDriverException(s);
        }
        catch (XMLDriverException e) {
            String s = LogUtil.error(this.getClass(), "Error writing XML data to file $0.", fileName, e);
            throw new XMLDriverException(s);
        }
    }

    public void serialize(Object o, OutputStream out) throws XMLDriverException {
        try {
            this.serialize(o, new OutputStreamWriter(out, this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            String s = LogUtil.error(this.getClass(), "Unsupported encoding $0.", this.encoding, e);
            throw new XMLDriverException(s);
        }
    }

    private void serialize(Object o, Writer writer) {
        Class<?> cls = o.getClass();
        this.loadMapping(cls);
        try {
            Marshaller marshaller = this.getContext().createMarshaller();
            marshaller.setWriter(writer);
            marshaller.marshal(o);
        }
        catch (Throwable t) {
            String s = LogUtil.error(this.getClass(), "Error serializing an object of class $0 to XML.", cls.getName(), t);
            throw new XMLDriverException(s);
        }
    }

    public void serialize(Object o, Node node) throws XMLDriverException {
        Class<?> cls = o.getClass();
        this.loadMapping(cls);
        try {
            Marshaller marshaller = this.getContext().createMarshaller();
            if (this.encoding != null) {
                marshaller.setEncoding(this.encoding);
            }
            Marshaller.marshal((Object)o, (Node)node);
        }
        catch (Throwable t) {
            String s = LogUtil.error(this.getClass(), "Error serializing an object of class $0 to XML.", cls.getName(), t);
            throw new XMLDriverException(s);
        }
    }

    public Object deserializeFile(String fileName) throws XMLDriverException {
        return this.deserializeFile(null, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserializeFile(Class cls, String fileName) throws XMLDriverException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            String s = LogUtil.error(this.getClass(), "Cannot open file $0.", fileName);
            throw new XMLDriverException(s);
        }
        try {
            Object object = this.deserializeStream(cls, in);
            return object;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }

    public Object deserializeResource(Resource resource) throws XMLDriverException {
        return this.deserializeResource(null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserializeResource(Class cls, Resource resource) throws XMLDriverException {
        InputStream in = null;
        try {
            in = resource.getInputStream();
        }
        catch (IOException e) {
            throw new XMLDriverException("Resource '" + resource.getDescription() + "' not found. ", e);
        }
        try {
            Object object = this.deserializeStream(cls, in);
            return object;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }

    public Object deserializeStream(Class cls, InputStream in) throws XMLDriverException {
        if (cls != null) {
            this.loadMapping(cls);
        }
        try {
            InputStreamReader isr = new InputStreamReader(in);
            Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
            if (cls != null) {
                unmarshaller.setClass(cls);
            }
            unmarshaller.setValidation(this.debugMode);
            return unmarshaller.unmarshal((Reader)isr);
        }
        catch (Throwable t) {
            String className = cls != null ? cls.getName() : "<unknown>";
            String s = LogUtil.error(this.getClass(), "Error deserializing an object of class $0 from XML.", className, t);
            throw new XMLDriverException(s);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean loadMappings(Iterator itClasses) {
        boolean success = true;
        while (itClasses.hasNext()) {
            Class cls = (Class)itClasses.next();
            try {
                this.loadMapping(cls);
            }
            catch (XMLDriverException e) {
                LogUtil.error(this.getClass(), "Error loading mapping.", e);
                success = false;
            }
        }
        return success;
    }

    public boolean loadMappings(Class[] classes) {
        boolean success = true;
        for (int i = 0; i < classes.length; ++i) {
            try {
                this.loadMapping(classes[i]);
                continue;
            }
            catch (XMLDriverException e) {
                LogUtil.error(this.getClass(), "Error loading mapping.", e);
                success = false;
            }
        }
        return success;
    }

    public void loadMapping(Class cls) throws XMLDriverException {
        Object o = this.mappedClasses.get(cls);
        if (o != null) {
            return;
        }
        this.context = null;
        String className = cls.getName();
        int index = className.lastIndexOf(46);
        String mappingFileName = className.substring(index + 1);
        URL url = cls.getResource(mappingFileName = mappingFileName + "Map.xml");
        if (url == null) {
            this.mappedClasses.put(cls, Boolean.FALSE);
            String s = LogUtil.error(this.getClass(), "Mapping resource not found for class $0.", className);
            throw new XMLDriverException(s);
        }
        try {
            this.mapping.loadMapping(url);
        }
        catch (Throwable t) {
            this.mappedClasses.put(cls, Boolean.FALSE);
            String s = LogUtil.error(this.getClass(), "Error loading mapping resource for class $0.", className, t);
            throw new XMLDriverException(s);
        }
        Class superClass = cls.getSuperclass();
        if (superClass != null && superClass.getName().startsWith("org.openbp.")) {
            try {
                this.loadMapping(superClass);
            }
            catch (XMLDriverException e) {
                this.mappedClasses.put(cls, Boolean.FALSE);
                throw e;
            }
        }
        this.mappedClasses.put(cls, Boolean.TRUE);
    }

    public void loadMapping(File file) throws XMLDriverException {
        URL url;
        try {
            url = file.toURL();
        }
        catch (MalformedURLException e) {
            String s = LogUtil.error(this.getClass(), "Mapping file $0 does not exist", file, e);
            throw new XMLDriverException(s);
        }
        try {
            this.mapping.loadMapping(url);
        }
        catch (Throwable t) {
            String s = LogUtil.error(this.getClass(), "Error loading mapping resource from file $0.", file.getPath(), t);
            throw new XMLDriverException(s);
        }
    }

    public Mapping getMapping() {
        return this.mapping;
    }
}

