/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.logger;

import java.util.concurrent.ConcurrentHashMap;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.MsgFormat;
import org.openbp.common.string.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.Reflection;

public final class LogUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static ConcurrentHashMap<String, Logger> loggerMap = new ConcurrentHashMap(100);

    private LogUtil() {
    }

    public static String debug(Class cls, String msg) {
        return LogUtil.log("Debug", cls, msg);
    }

    public static String debug(Class cls, String msg, Object arg1) {
        return LogUtil.log("Debug", cls, msg, arg1);
    }

    public static String debug(Class cls, String msg, Object arg1, Object arg2) {
        return LogUtil.log("Debug", cls, msg, arg1, arg2);
    }

    public static String debug(Class cls, String msg, Object arg1, Object arg2, Object arg3) {
        return LogUtil.log("Debug", cls, msg, arg1, arg2, arg3);
    }

    public static String debug(Class cls, String msg, Object arg1, Object arg2, Object arg3, Object arg4) {
        return LogUtil.log("Debug", cls, msg, arg1, arg2, arg3, arg4);
    }

    public static String debug(Class cls, String msg, Object[] args) {
        return LogUtil.log("Debug", cls, msg, args);
    }

    public static String trace(Class cls, String msg) {
        return LogUtil.log("Trace", cls, msg);
    }

    public static String trace(Class cls, String msg, Object arg1) {
        return LogUtil.log("Trace", cls, msg, arg1);
    }

    public static String trace(Class cls, String msg, Object arg1, Object arg2) {
        return LogUtil.log("Trace", cls, msg, arg1, arg2);
    }

    public static String trace(Class cls, String msg, Object arg1, Object arg2, Object arg3) {
        return LogUtil.log("Trace", cls, msg, arg1, arg2, arg3);
    }

    public static String trace(Class cls, String msg, Object arg1, Object arg2, Object arg3, Object arg4) {
        return LogUtil.log("Trace", cls, msg, arg1, arg2, arg3, arg4);
    }

    public static String trace(Class cls, String msg, Object[] args) {
        return LogUtil.log("Trace", cls, msg, args);
    }

    public static String info(Class cls, String msg) {
        return LogUtil.log("Info", cls, msg);
    }

    public static String info(Class cls, String msg, Object arg1) {
        return LogUtil.log("Info", cls, msg, arg1);
    }

    public static String info(Class cls, String msg, Object arg1, Object arg2) {
        return LogUtil.log("Info", cls, msg, arg1, arg2);
    }

    public static String info(Class cls, String msg, Object arg1, Object arg2, Object arg3) {
        return LogUtil.log("Info", cls, msg, arg1, arg2, arg3);
    }

    public static String info(Class cls, String msg, Object arg1, Object arg2, Object arg3, Object arg4) {
        return LogUtil.log("Info", cls, msg, arg1, arg2, arg3, arg4);
    }

    public static String info(Class cls, String msg, Object[] args) {
        return LogUtil.log("Info", cls, msg, args);
    }

    public static String warn(Class cls, String msg) {
        return LogUtil.log("Warn", cls, msg);
    }

    public static String warn(Class cls, String msg, Object arg1) {
        return LogUtil.log("Warn", cls, msg, arg1);
    }

    public static String warn(Class cls, String msg, Object arg1, Object arg2) {
        return LogUtil.log("Warn", cls, msg, arg1, arg2);
    }

    public static String warn(Class cls, String msg, Object arg1, Object arg2, Object arg3) {
        return LogUtil.log("Warn", cls, msg, arg1, arg2, arg3);
    }

    public static String warn(Class cls, String msg, Object arg1, Object arg2, Object arg3, Object arg4) {
        return LogUtil.log("Warn", cls, msg, arg1, arg2, arg3, arg4);
    }

    public static String warn(Class cls, String msg, Object[] args) {
        return LogUtil.log("Warn", cls, msg, args);
    }

    public static String error(Class cls, String msg) {
        return LogUtil.log("Error", cls, msg);
    }

    public static String error(Class cls, String msg, Object arg1) {
        return LogUtil.log("Error", cls, msg, arg1);
    }

    public static String error(Class cls, String msg, Object arg1, Object arg2) {
        return LogUtil.log("Error", cls, msg, arg1, arg2);
    }

    public static String error(Class cls, String msg, Object arg1, Object arg2, Object arg3) {
        return LogUtil.log("Error", cls, msg, arg1, arg2, arg3);
    }

    public static String error(Class cls, String msg, Object arg1, Object arg2, Object arg3, Object arg4) {
        return LogUtil.log("Error", cls, msg, arg1, arg2, arg3, arg4);
    }

    public static String error(Class cls, String msg, Object[] args) {
        return LogUtil.log("Error", cls, msg, args);
    }

    public static String log(String logLevel, Class cls, String msg) {
        if (!LogUtil.shouldDoLog(logLevel, cls)) {
            return null;
        }
        Object[] nullArgs = null;
        return LogUtil.log(logLevel, cls, msg, nullArgs);
    }

    public static String log(String logLevel, Class cls, String msg, Object arg1) {
        if (!LogUtil.shouldDoLog(logLevel, cls)) {
            return null;
        }
        return LogUtil.log(logLevel, cls, msg, new Object[]{arg1});
    }

    public static String log(String logLevel, Class cls, String msg, Object arg1, Object arg2) {
        if (!LogUtil.shouldDoLog(logLevel, cls)) {
            return null;
        }
        return LogUtil.log(logLevel, cls, msg, new Object[]{arg1, arg2});
    }

    public static String log(String logLevel, Class cls, String msg, Object arg1, Object arg2, Object arg3) {
        if (!LogUtil.shouldDoLog(logLevel, cls)) {
            return null;
        }
        return LogUtil.log(logLevel, cls, msg, new Object[]{arg1, arg2, arg3});
    }

    public static String log(String logLevel, Class cls, String msg, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (!LogUtil.shouldDoLog(logLevel, cls)) {
            return null;
        }
        return LogUtil.log(logLevel, cls, msg, new Object[]{arg1, arg2, arg3, arg4});
    }

    public static String log(String logLevel, Class cls, String msg, Object[] args) {
        return LogUtil.doLog(logLevel, cls, msg, args);
    }

    public static String log(String logLevel, String loggerName, String msg, Object[] args) {
        return LogUtil.doLog(logLevel, loggerName, msg, args);
    }

    public static String doLog(String logLevel, Class cls, String msg, Object[] args) {
        return LogUtil.doLog(logLevel, cls != null ? cls.getName() : null, msg, args);
    }

    public static boolean isDebugEnabled(Class cls) {
        return LogUtil.isLoggerEnabled(cls, "Debug");
    }

    public static boolean isInfoEnabled(Class cls) {
        return LogUtil.isLoggerEnabled(cls, "Info");
    }

    public static boolean isTraceEnabled(Class cls) {
        return LogUtil.isLoggerEnabled(cls, "Trace");
    }

    public static boolean isWarnEnabled(Class cls) {
        return LogUtil.isLoggerEnabled(cls, "Warn");
    }

    public static boolean isErrorEnabled(Class cls) {
        return LogUtil.isLoggerEnabled(cls, "Error");
    }

    public static boolean isLoggerEnabled(Class cls, String logLevel) {
        return LogUtil.isLoggerEnabled(cls != null ? cls.getName() : null, logLevel);
    }

    public static boolean isLoggerEnabled(String loggerName, String logLevel) {
        Logger logger = LogUtil.mapLogger(loggerName);
        if ("Debug".equalsIgnoreCase(logLevel)) {
            return logger.isDebugEnabled();
        }
        if ("Trace".equalsIgnoreCase(logLevel)) {
            return logger.isTraceEnabled();
        }
        if ("Info".equalsIgnoreCase(logLevel)) {
            return logger.isInfoEnabled();
        }
        if ("Warn".equalsIgnoreCase(logLevel)) {
            return logger.isWarnEnabled();
        }
        if ("Error".equalsIgnoreCase(logLevel)) {
            return logger.isErrorEnabled();
        }
        return true;
    }

    private static boolean shouldDoLog(String logLevel, Class cls) {
        if ("Error".equals(logLevel)) {
            return true;
        }
        return LogUtil.isLoggerEnabled(cls, logLevel);
    }

    private static void printLog(String loggerName, String logLevel, String msg, Throwable throwable) {
        Logger logger = LogUtil.mapLogger(loggerName);
        if ("Debug".equalsIgnoreCase(logLevel)) {
            if (throwable != null) {
                logger.debug(msg, throwable);
            } else {
                logger.debug(msg);
            }
        } else if ("Trace".equalsIgnoreCase(logLevel)) {
            if (throwable != null) {
                logger.trace(msg, throwable);
            } else {
                logger.trace(msg);
            }
        } else if ("Info".equalsIgnoreCase(logLevel)) {
            if (throwable != null) {
                logger.info(msg, throwable);
            } else {
                logger.info(msg);
            }
        } else if ("Warn".equalsIgnoreCase(logLevel)) {
            if (throwable != null) {
                logger.warn(msg, throwable);
            } else {
                logger.warn(msg);
            }
        } else if ("Error".equalsIgnoreCase(logLevel)) {
            if (throwable != null) {
                logger.error(msg, throwable);
            } else {
                logger.error(msg);
            }
        } else if (throwable != null) {
            logger.warn("Unknown log level for message '" + msg + "' for logger '" + loggerName + "'.");
        } else {
            logger.warn("Unknown log level for message '" + msg + "' for logger '" + loggerName + "'.", throwable);
        }
    }

    public static String doLog(String logLevel, String loggerName, String msg, Object[] args) {
        String exceptionMsg;
        boolean enabled = true;
        if (!LogUtil.isLoggerEnabled(loggerName, logLevel)) {
            if (logLevel != "Error") {
                return null;
            }
            enabled = false;
        }
        Throwable throwable = null;
        if (args != null && args.length > 0) {
            boolean needFormatting = true;
            Object t = args[args.length - 1];
            if (t instanceof Throwable) {
                throwable = (Throwable)t;
                if (args.length == 1) {
                    needFormatting = false;
                }
            }
            if (needFormatting) {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] != null) continue;
                    args[i] = "(null)";
                }
                try {
                    msg = MsgFormat.format(msg, args);
                }
                catch (Exception e) {
                    String fMsg = "Logging error: Can't format message '" + msg + "' with " + args.length + " arguments.\n\tException:\n\t" + ExceptionUtil.getNestedTrace(e);
                    LogUtil.mapLogger(LogUtil.class.getName()).error(fMsg);
                }
            }
        }
        String retMsg = msg;
        String logMsg = msg;
        if (throwable != null && (exceptionMsg = ExceptionUtil.getNestedMessage(throwable)) != null) {
            retMsg = retMsg + '\n';
            retMsg = retMsg + exceptionMsg;
            if (enabled) {
                logMsg = logMsg + '\n';
                logMsg = logMsg + exceptionMsg;
            }
        }
        if (enabled) {
            if (!LINE_SEPARATOR.equals("\n")) {
                logMsg = StringUtil.substitute(logMsg, "\n", LINE_SEPARATOR);
            }
            LogUtil.printLog(loggerName, logLevel, logMsg, throwable);
        }
        return retMsg;
    }

    private static Logger mapLogger(String loggerName) {
        Logger logger;
        if (loggerName == null) {
            loggerName = "ROOT";
        }
        if ((logger = loggerMap.get(loggerName)) == null) {
            logger = LoggerFactory.getLogger((String)loggerName);
            loggerMap.put(loggerName, logger);
        }
        return logger;
    }

    private static String getCallerClassName() {
        return Reflection.getCallerClass((int)2).getName();
    }
}

