/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.markup;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMFactory {
    private Document doc;

    public DOMFactory() {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            this.doc = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public DOMFactory(String rootTag) {
        this();
        Element rootElement = this.doc.createElement(rootTag);
        this.doc.appendChild(rootElement);
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setDocument(Document doc) {
        this.doc = doc;
    }

    public Element getRootElement() {
        return this.doc.getDocumentElement();
    }

    public Element createTextOrEmptyNode(Element parent, String nodeName, String value) {
        Element item = this.doc.createElement(nodeName);
        if (value != null) {
            item.appendChild(this.doc.createTextNode(value));
        }
        if (parent != null) {
            parent.appendChild(item);
        }
        return item;
    }

    public Element createTextNode(Element parent, String nodeName, String value) {
        Element item = this.createTextNode(nodeName, value);
        if (parent != null && item != null) {
            parent.appendChild(item);
        }
        return item;
    }

    public Element createTextNode(String nodeName, String value) {
        if (value == null) {
            return null;
        }
        Element item = this.doc.createElement(nodeName);
        item.appendChild(this.doc.createTextNode(value));
        return item;
    }

    public Element createTextNode(String nodeName, int value) {
        return this.createTextNode(nodeName, String.valueOf(value));
    }

    public Element createTextNode(String nodeName, Integer value) {
        if (value == null) {
            return null;
        }
        return this.createTextNode(nodeName, value.toString());
    }

    public Element createTextNode(String nodeName, boolean value) {
        if (!value) {
            return null;
        }
        return this.createTextNode(nodeName, String.valueOf(value));
    }

    public Element createElement(String nodeName) {
        return this.doc.createElement(nodeName);
    }

    public Element createElement(Element parent, String nodeName) {
        Element e = this.doc.createElement(nodeName);
        parent.appendChild(e);
        return e;
    }
}

