/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.rc;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionException;
import org.openbp.common.resource.ResourceMgr;
import org.openbp.common.resource.ResourceMgrException;
import org.openbp.common.string.StringReplacer;
import org.xml.sax.SAXException;

public class ResourceCollectionMgr {
    public static final String RC_FOLDER = "rc";
    public static final String DEFAULT_LOCALE = "default";
    public static final String MEDIA_SUFFIX = ".rc.xml";
    private Map resourceTable = new HashMap();
    private StringReplacer resourceVariableReplacer;
    private ResourceMgr resourceMgr = ResourceMgr.getDefaultInstance();
    private static ResourceCollectionMgr singletonInstance;

    public static synchronized ResourceCollectionMgr getDefaultInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ResourceCollectionMgr();
        }
        return singletonInstance;
    }

    public ResourceCollection getResource(String containerName, String resourceName) {
        return this.getResource(containerName, resourceName, null);
    }

    public ResourceCollection getResource(String containerName, Class cls) {
        return this.getResource(containerName, cls, null);
    }

    public ResourceCollection getResource(String containerName, Class cls, Locale locale) {
        String name = cls.getName();
        if (name.startsWith("org.openbp.")) {
            name = name.substring("org.openbp.".length());
        }
        return this.getResource(containerName, name, locale);
    }

    public ResourceCollection getResource(String containerName, String resourceName, Locale locale) {
        Object o;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Locale initialLocale = locale;
        ResourceMgrException recentException = null;
        String key = null;
        ResourceCollection res = null;
        while (!((o = this.resourceTable.get(key = ResourceCollectionMgr.constructResourceCollectionLocalPath(containerName, locale, resourceName))) instanceof Boolean)) {
            if (o instanceof ResourceCollection) {
                res = (ResourceCollection)o;
                break;
            }
            try {
                InputStream stream = this.resourceMgr.openResource(key + MEDIA_SUFFIX);
                res = new ResourceCollection(containerName, resourceName, locale, this, stream);
                this.resourceTable.put(key, res);
            }
            catch (ResourceMgrException e) {
                recentException = e;
            }
            catch (IOException e) {
                throw new ResourceCollectionException("I/O error reading resource collection '" + key + "'.", e);
            }
            catch (SAXException e) {
                throw new ResourceCollectionException("XML error reading resource collection '" + key + "'.", e);
            }
            if (locale == null) break;
            locale = this.determineParentLocale(locale);
        }
        if (res == null) {
            this.resourceTable.put(key, Boolean.FALSE);
        }
        if (locale != initialLocale) {
            String initialKey = ResourceCollectionMgr.constructResourceCollectionLocalPath(containerName, initialLocale, resourceName);
            if (res != null) {
                this.resourceTable.put(initialKey, res);
            } else {
                this.resourceTable.put(initialKey, Boolean.FALSE);
            }
        }
        if (res == null && recentException != null) {
            throw new ResourceCollectionException("Resource collection '" + containerName + "/" + resourceName + "' could not be found.", recentException);
        }
        return res;
    }

    public static String constructResourceCollectionLocalPath(String containerName, Locale locale, String resourceName) {
        StringBuffer sb = new StringBuffer(255);
        sb.append(RC_FOLDER);
        sb.append("/");
        if (containerName != null) {
            sb.append(containerName);
            sb.append("/");
        }
        String localeName = null;
        localeName = locale != null ? locale.toString() : DEFAULT_LOCALE;
        sb.append(localeName);
        sb.append("/");
        sb.append(resourceName);
        return sb.toString();
    }

    public Locale determineParentLocale(Locale locale) {
        String variant = locale.getVariant();
        String country = locale.getCountry();
        String language = locale.getLanguage();
        Locale parentLocale = null;
        if (!variant.equals("")) {
            parentLocale = new Locale(language, country, "");
        } else if (!country.equals("")) {
            parentLocale = new Locale(language, "", "");
        } else if (!language.equals("")) {
            parentLocale = null;
        }
        return parentLocale;
    }

    public void addResourceVariable(String pattern, String replacement) {
        if (this.resourceVariableReplacer == null) {
            this.resourceVariableReplacer = new StringReplacer();
        }
        this.resourceVariableReplacer.addReplacement(pattern, replacement);
    }

    public String performVariableReplacement(String text) {
        if (this.resourceVariableReplacer != null && text != null) {
            text = this.resourceVariableReplacer.process(text);
        }
        return text;
    }

    public ResourceMgr getResourceMgr() {
        return this.resourceMgr;
    }
}

