/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.rc;

import java.util.HashMap;
import java.util.Map;
import org.openbp.common.ReflectUtil;
import org.openbp.common.string.StringUtil;

public final class ResourceItemTypes {
    public static final String TEXT_PLAIN = "text/plain";
    public static final String IMAGE_GIF = "image/gif";
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final String IMAGE_PNG = "image/png";
    public static final String IMAGE_BMP = "image/bmp";
    public static final String MULTIICON = "image/multi";
    public static final String PRIMITIVE_INTEGER = "primitive/integer";
    public static final String PRIMITIVE_CHARACTER = "primitive/character";
    public static final String DATA_KEYSTROKE = "data/keystroke";
    private static final String PACKAGE = "org.openbp.common.rc";
    private static Map resourceItemTypeInfos = new HashMap();

    private ResourceItemTypes() {
    }

    public static Class determineResourceItemClass(String mimeType) {
        Class cls = (Class)resourceItemTypeInfos.get(mimeType);
        if (cls == null) {
            String className = ResourceItemTypes.determineResourceItem(mimeType);
            cls = ReflectUtil.loadClass(className);
            resourceItemTypeInfos.put(mimeType, cls);
        }
        return cls;
    }

    private static String determineResourceItem(String mimeType) {
        mimeType = mimeType.toLowerCase();
        StringBuffer sb = new StringBuffer(200);
        sb.append(PACKAGE);
        sb.append('.');
        String tmp = mimeType.replace('.', '_');
        tmp = tmp.replace('-', '_');
        tmp = tmp.replace('\\', '/');
        int index = tmp.indexOf(47);
        if (index > 0) {
            sb.append(tmp.substring(0, index));
            sb.append('.');
            sb.append('T');
            sb.append(StringUtil.capitalize(tmp.substring(index + 1)));
        } else {
            sb.append('T');
            sb.append(StringUtil.capitalize(tmp));
        }
        return sb.toString();
    }
}

