/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.rc.image;

import org.openbp.common.icon.MultiImageIcon;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.markup.XMLUtil;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceItem;
import org.openbp.common.string.StringUtil;
import org.w3c.dom.Element;

public class TMulti
extends ResourceItem {
    protected static final String TAG_IMAGE_PATH = "path";
    protected static final String[] EXTENSIONS = new String[]{"png", "gif", "jpg", "jpeg", "tif"};
    private String path;

    @Override
    public void initializeFromDOM(ResourceCollection res, Element sourceElement, String group) {
        super.initializeFromDOM(res, sourceElement, group);
        this.path = XMLUtil.getChildNodeValue(sourceElement, TAG_IMAGE_PATH);
        if (this.path == null) {
            LogUtil.error(this.getClass(), "Resource $0: Missing or invalid tag $1.", this.getErrorName(), TAG_IMAGE_PATH);
            return;
        }
        this.path = res.getResourceCollectionMgr().performVariableReplacement(this.path);
        this.path = StringUtil.normalizePathName(this.path);
        if (!this.checkFileExtension(this.path.substring(this.path.lastIndexOf(46) + 1))) {
            LogUtil.error(this.getClass(), "Resource $0: Unsupported image file name extension for mim type $1.", this.getErrorName(), this.getMimeType());
            return;
        }
        this.path = res.getResourceItemPath(this.path);
    }

    public String getMimeType() {
        return "image/multi";
    }

    @Override
    protected Object loadResourceObject() {
        if (this.path == null) {
            return null;
        }
        MultiImageIcon image = new MultiImageIcon(this.path, this.getResourceCollection().getResourceCollectionMgr().getResourceMgr());
        return image;
    }

    public String getPath() {
        return this.path;
    }

    protected boolean checkFileExtension(String extension) {
        extension = extension.toLowerCase();
        for (int i = 0; i < EXTENSIONS.length; ++i) {
            if (!extension.equals(EXTENSIONS[i])) continue;
            return true;
        }
        return false;
    }
}

