/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.string;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Object2StringConverter {
    private Map value2Str = new LinkedHashMap();
    private Map str2Value = new LinkedHashMap();
    private ArrayList displayNames = new ArrayList();
    private Object defaultValue;

    public void addValue(Object value, String name, String displayName) {
        this.value2Str.put(value, name);
        this.str2Value.put(name, value);
        this.displayNames.add(displayName);
    }

    public Object str2Value(String str) {
        Object o;
        Object ret = this.defaultValue;
        if (str != null && (o = this.str2Value.get(str)) != null) {
            ret = o;
        }
        return ret;
    }

    public String value2Str(Object value) {
        String ret = null;
        if (!(value == null || this.defaultValue != null && this.defaultValue.equals(value))) {
            ret = (String)this.value2Str.get(value);
        }
        return ret;
    }

    public boolean checkValue(Object value) {
        return value == null || this.value2Str.get(value) != null;
    }

    public Iterator getValues() {
        return this.value2Str.keySet().iterator();
    }

    public Iterator getStrings() {
        return this.str2Value.keySet().iterator();
    }

    public Iterator getDisplayNames() {
        return this.displayNames.iterator();
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void addIntValue(int value, String name, String displayName) {
        this.addValue(new Integer(value), name, displayName);
    }

    public int str2IntValue(String str) {
        Object o = this.str2Value(str);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (this.defaultValue instanceof Integer) {
            return (Integer)this.defaultValue;
        }
        return -1;
    }

    public String intValue2Str(int value) {
        return this.value2Str(new Integer(value));
    }

    public boolean checkIntValue(int value) {
        return value == -1 || this.checkValue(new Integer(value));
    }
}

