/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.string;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.openbp.common.CollectionUtil;

public final class StringUtil {
    public static final String FOLDER_SEP = "/";
    public static final char FOLDER_SEP_CHAR = '/';

    private StringUtil() {
    }

    public static String[] tokenize(String string, String separator) {
        return StringUtil.tokenize(string, separator, false);
    }

    public static String[] tokenize(String string, String separator, boolean trim) {
        StringTokenizer tokenizer = new StringTokenizer(string, separator);
        ArrayList<String> parts = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (trim) {
                token = token.trim();
            }
            parts.add(token);
        }
        return CollectionUtil.toStringArray(parts);
    }

    public static String detokenize(String[] strings, char separatorChar) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            result.append(separatorChar);
            result.append(strings[i]);
        }
        return result.toString();
    }

    public static int indexOfIgnoreCase(String s, int startIndex, String pattern) {
        if (s == null || pattern == null) {
            return -1;
        }
        int patLen = pattern.length();
        if (patLen == 0) {
            return -1;
        }
        int len = s.length();
        for (int i = startIndex; i < len; ++i) {
            if (!s.regionMatches(true, i, pattern, 0, patLen)) continue;
            return i;
        }
        return -1;
    }

    public static String substituteIgnoreCase(String s, String pattern, String replacement) {
        if (s == null || pattern == null) {
            return s;
        }
        int patLen = pattern.length();
        if (patLen == 0) {
            return s;
        }
        StringBuffer sb = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (s.regionMatches(true, i, pattern, 0, patLen)) {
                if (sb == null) {
                    sb = new StringBuffer(len > 16 ? len : 16);
                    sb.append(s.substring(0, i));
                }
                sb.append(replacement);
                i += patLen - 1;
                continue;
            }
            if (sb == null) continue;
            sb.append(s.charAt(i));
        }
        return sb != null ? sb.toString() : s;
    }

    public static String substituteIgnoreCase(String s, Map map) {
        return StringUtil.substitute(s, map, true);
    }

    public static String substitute(String s, String pattern, String replacement) {
        if (s == null || pattern == null) {
            return s;
        }
        if (s.indexOf(pattern) < 0) {
            return s;
        }
        int patLen = pattern.length();
        if (patLen == 0) {
            return s;
        }
        int len = s.length();
        StringBuffer sb = new StringBuffer(len > 16 ? len : 16);
        for (int i = 0; i < len; ++i) {
            if (s.startsWith(pattern, i)) {
                if (replacement != null) {
                    sb.append(replacement);
                }
                i += patLen - 1;
                continue;
            }
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    public static String substitute(String s, Map map) {
        return StringUtil.substitute(s, map, false);
    }

    private static String substitute(String s, Map map, boolean ignoreCase) {
        if (s == null || map == null) {
            return s;
        }
        Set patternSet = map.keySet();
        if (patternSet.size() == 0) {
            return s;
        }
        StringBuffer sb = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            String matchingPattern = null;
            for (String pattern : patternSet) {
                boolean match = ignoreCase ? s.regionMatches(true, i, pattern, 0, pattern.length()) : s.startsWith(pattern, i);
                if (!match) continue;
                matchingPattern = pattern;
                break;
            }
            if (matchingPattern != null) {
                if (sb == null) {
                    sb = new StringBuffer(len > 16 ? len : 16);
                    sb.append(s.substring(0, i));
                }
                sb.append((String)map.get(matchingPattern));
                i += matchingPattern.length() - 1;
                continue;
            }
            if (sb == null) continue;
            sb.append(s.charAt(i));
        }
        return sb != null ? sb.toString() : s;
    }

    public static String capitalize(String name) {
        char c;
        if (name != null && name.length() > 0 && Character.isLowerCase(c = name.charAt(0))) {
            StringBuffer sb = new StringBuffer(name);
            sb.setCharAt(0, Character.toUpperCase(c));
            name = sb.toString();
        }
        return name;
    }

    public static String decapitalize(String name) {
        char c;
        if (name != null && name.length() > 0 && Character.isUpperCase(c = name.charAt(0))) {
            StringBuffer sb = new StringBuffer(name);
            sb.setCharAt(0, Character.toLowerCase(c));
            name = sb.toString();
        }
        return name;
    }

    public static String absolutePathName(String s) {
        if (s != null) {
            try {
                s = new File(s).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            s = s.replace('\\', '/');
        }
        return s;
    }

    public static String normalizePathName(String path) {
        if (path != null && path.length() > 0) {
            if ((path = path.replace('\\', '/')).indexOf("./") >= 0 || path.indexOf("/.") >= 0) {
                String prefix = null;
                int prefixIndex = path.indexOf(":");
                if (prefixIndex >= 0) {
                    prefix = path.substring(0, prefixIndex + 1);
                    path = path.substring(prefixIndex + 1);
                }
                boolean isRootPath = false;
                if (path.charAt(0) == '/') {
                    isRootPath = true;
                }
                String[] dirs = StringUtil.tokenize(path, FOLDER_SEP, false);
                ArrayList<String> res = new ArrayList<String>();
                for (int i = 0; i < dirs.length; ++i) {
                    String s = dirs[i];
                    if (s.equals("..")) {
                        int rn = res.size();
                        if (rn >= 1 && !res.get(rn - 1).equals("..")) {
                            res.remove(rn - 1);
                            continue;
                        }
                    } else if (s.equals(".")) continue;
                    res.add(dirs[i]);
                }
                StringBuffer sb = new StringBuffer();
                if (prefix != null) {
                    sb.append(prefix);
                }
                if (isRootPath) {
                    sb.append('/');
                }
                boolean first = true;
                Iterator it = res.iterator();
                while (it.hasNext()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(FOLDER_SEP);
                    }
                    sb.append(it.next());
                }
                path = sb.toString();
            } else {
                int n = path.length();
                if (path.charAt(n - 1) == '/') {
                    path = path.substring(0, n - 1);
                }
            }
        }
        return path;
    }

    public static String normalizeDir(String path) {
        if (path != null) {
            if ((path = StringUtil.normalizePathName(path)).charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.charAt(path.length() - 1) == '/') {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    public static String buildPath(String p1, String p2) {
        p1 = StringUtil.normalizePathName(p1);
        p2 = StringUtil.normalizePathName(p2);
        if (p1 != null && p1.length() == 0) {
            p1 = null;
        }
        if (p2 != null && p2.length() == 0) {
            p2 = null;
        }
        if (p2 == null) {
            return p1;
        }
        if (p1 == null) {
            return p2;
        }
        if (p1.charAt(p1.length() - 1) == '/') {
            p1 = p1.substring(0, p1.length() - 1);
        }
        if (p2.charAt(0) == '/') {
            p2 = p2.substring(1);
        }
        return p1 + FOLDER_SEP + p2;
    }

    public static void append(StringBuffer sb, String s1, String s2) {
        sb.append(s1);
        sb.append(s2);
    }

    public static void append(StringBuffer sb, String s1, String s2, String s3) {
        sb.append(s1);
        sb.append(s2);
        sb.append(s3);
    }

    public static void append(StringBuffer sb, String s1, String s2, String s3, String s4) {
        sb.append(s1);
        sb.append(s2);
        sb.append(s3);
        sb.append(s4);
    }

    public static void append(StringBuffer sb, String s1, String s2, String s3, String s4, String s5) {
        sb.append(s1);
        sb.append(s2);
        sb.append(s3);
        sb.append(s4);
        sb.append(s5);
    }

    public static void appendLine(StringBuffer sb, String s1) {
        sb.append(s1);
        sb.append('\n');
    }

    public static void appendLine(StringBuffer sb, String s1, String s2) {
        StringUtil.append(sb, s1, s2);
        sb.append('\n');
    }

    public static void appendLine(StringBuffer sb, String s1, String s2, String s3) {
        StringUtil.append(sb, s1, s2, s3);
        sb.append('\n');
    }

    public static void appendLine(StringBuffer sb, String s1, String s2, String s3, String s4) {
        StringUtil.append(sb, s1, s2, s3, s4);
        sb.append('\n');
    }

    public static void appendLine(StringBuffer sb, String s1, String s2, String s3, String s4, String s5) {
        StringUtil.append(sb, s1, s2, s3, s4, s5);
        sb.append('\n');
    }

    public static char safeCharAt(String s, int index) {
        if (index >= 0 && index < s.length()) {
            return s.charAt(index);
        }
        return '\u0000';
    }

    public static String trimNull(String s) {
        if (s != null && (s = s.trim()).length() == 0) {
            s = null;
        }
        return s;
    }

    public static String int2String(int i) {
        return Integer.toString(i, 10);
    }

    public static boolean string2boolean(String value) {
        boolean b = new Boolean(value);
        if (b) {
            return b;
        }
        if (value != null && "false".equalsIgnoreCase(value)) {
            return b;
        }
        throw new IllegalArgumentException("The value '" + value + "' is not a boolean value.");
    }

    public static String trim(String origin, char[] trimCharacters) {
        int lenBuffer;
        if (origin == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int lenOrigin = origin.length();
        for (int i = 0; i < lenOrigin; ++i) {
            char c = origin.charAt(i);
            boolean characterFound = false;
            for (int j = 0; j < trimCharacters.length; ++j) {
                if (c != trimCharacters[j]) continue;
                characterFound = true;
                break;
            }
            if (characterFound) continue;
            buf.append(origin.substring(i));
            break;
        }
        for (int i = lenBuffer = buf.length(); i > 0; --i) {
            char c = buf.charAt(i - 1);
            boolean characterFound = false;
            for (int j = 0; j < trimCharacters.length; ++j) {
                if (c != trimCharacters[j]) continue;
                characterFound = true;
                break;
            }
            if (characterFound) continue;
            buf.setLength(i);
            break;
        }
        return buf.toString();
    }

    public static boolean contains(String s, String[] list) {
        if (s != null && list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (!s.equals(list[i])) continue;
                return true;
            }
        }
        return false;
    }
}

