/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util;

import java.util.ArrayList;
import java.util.Collection;
import org.openbp.common.CommonUtil;
import org.openbp.common.generic.description.DescriptionObject;

public final class NamedObjectCollectionUtil {
    private NamedObjectCollectionUtil() {
    }

    public static DescriptionObject getByName(Collection c, String name) {
        block4: {
            if (c == null) break block4;
            if (c instanceof ArrayList) {
                ArrayList list = (ArrayList)c;
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    DescriptionObject desc;
                    Object o = list.get(i);
                    if (!(o instanceof DescriptionObject) || !CommonUtil.equalsNull((desc = (DescriptionObject)o).getName(), name)) continue;
                    return desc;
                }
            } else {
                for (Object o : c) {
                    DescriptionObject desc;
                    if (!(o instanceof DescriptionObject) || !CommonUtil.equalsNull((desc = (DescriptionObject)o).getName(), name)) continue;
                    return desc;
                }
            }
        }
        return null;
    }

    public static String createUniqueId(Collection c, String typeName) {
        int i = 1;
        String n;
        DescriptionObject o;
        while ((o = NamedObjectCollectionUtil.getByName(c, n = i == 1 ? typeName : typeName + i)) != null) {
            ++i;
        }
        return n;
    }

    public static String createUniqueId(Collection toInsert, Collection inserted, Collection base, String typeName) {
        if (NamedObjectCollectionUtil.getByName(inserted, typeName) == null && NamedObjectCollectionUtil.getByName(base, typeName) == null) {
            return typeName;
        }
        int i = 2;
        String n;
        while (NamedObjectCollectionUtil.getByName(inserted, n = typeName + i) != null || NamedObjectCollectionUtil.getByName(base, n) != null) {
            ++i;
        }
        return n;
    }

    public static void createUniqueNames(Collection toInsert, Collection base) {
        if (toInsert == null || base == null) {
            return;
        }
        ArrayList<DescriptionObject> inserted = new ArrayList<DescriptionObject>();
        for (DescriptionObject element : toInsert) {
            String n = element.getName();
            n = NamedObjectCollectionUtil.cutTrailingDigits(n);
            n = NamedObjectCollectionUtil.createUniqueId(toInsert, inserted, base, n);
            element.setName(n);
            inserted.add(element);
        }
    }

    public static void createUniqueName(DescriptionObject element, Collection base) {
        if (element == null || base == null) {
            return;
        }
        ArrayList<DescriptionObject> toInsert = new ArrayList<DescriptionObject>();
        toInsert.add(element);
        String n = element.getName();
        n = NamedObjectCollectionUtil.cutTrailingDigits(n);
        n = NamedObjectCollectionUtil.createUniqueId(toInsert, null, base, n);
        element.setName(n);
    }

    private static String cutTrailingDigits(String s) {
        StringBuffer sb = new StringBuffer(s);
        int n = sb.length();
        for (int i = n - 1; i > 0; --i) {
            if (!Character.isDigit(sb.charAt(i))) continue;
            sb.setLength(i);
        }
        return sb.toString();
    }
}

