/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util;

public class PrimitiveArray {
    private int capacity = 0;
    private int oldCapacity = 0;
    private int size = 0;
    private Object array;
    private int defaultReturn = -1;

    public PrimitiveArray() {
        this(10);
    }

    public PrimitiveArray(int capacity) {
        this.capacity = capacity;
    }

    private void initialize() {
        this.array = new int[this.capacity];
        this.oldCapacity = this.capacity;
        this.clear();
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.capacity) {
            this.capacity = capacity;
        }
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        this.clear(0);
    }

    public void clear(int index) {
        if (this.array == null) {
            return;
        }
        if (this.array instanceof int[]) {
            int[] intArray = (int[])this.array;
            for (int i = index; i < intArray.length; ++i) {
                intArray[i] = this.defaultReturn;
            }
            this.size = index;
        }
    }

    public void set(int index, int value) {
        if (this.array == null) {
            this.initialize();
        }
        int[] intArray = this.ensureIntCapacity();
        intArray[index] = value;
        this.size = this.size < index ? index : this.size;
        ++this.size;
    }

    public int get(int index) {
        if (this.array == null || index >= this.size) {
            return this.defaultReturn;
        }
        return ((int[])this.array)[index];
    }

    public void add(int value) {
        if (this.array == null) {
            this.initialize();
        }
        int[] intArray = this.ensureIntCapacity();
        intArray[this.size++] = value;
    }

    public void setDefaultReturnValue(int value) {
        this.defaultReturn = value;
    }

    private int[] ensureIntCapacity() {
        if (this.size == this.capacity) {
            this.capacity = this.capacity * 3 / 2 + 1;
        }
        if (this.oldCapacity < this.capacity || this.size == this.capacity) {
            int[] intArray = new int[this.capacity];
            this.copyArray(intArray);
            return intArray;
        }
        return (int[])this.array;
    }

    private void copyArray(Object destinationArray) {
        if (this.array == null) {
            return;
        }
        System.arraycopy(this.array, 0, destinationArray, 0, this.oldCapacity);
        this.oldCapacity = this.capacity;
        this.array = destinationArray;
    }
}

