/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util;

import java.util.LinkedList;
import java.util.List;
import org.openbp.common.util.DisposalListener;

public class SizeRestrictedQueue {
    private List objects;
    private int maxSize;
    private DisposalListener disposalListener;

    public SizeRestrictedQueue(int maxSize) {
        this.maxSize = maxSize;
        this.objects = new LinkedList();
    }

    public int size() {
        return this.objects.size();
    }

    public void enqueue(Object obj, boolean removeExisting) {
        if (removeExisting) {
            this.objects.remove(obj);
        }
        this.objects.add(obj);
        this.ensureSizeRestriction();
    }

    public boolean contains(Object obj) {
        return this.objects.contains(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSizeRestriction() {
        List list = this.objects;
        synchronized (list) {
            while (this.objects.size() > this.maxSize) {
                Object disposedObject = this.objects.remove(0);
                if (this.disposalListener == null) continue;
                this.disposalListener.onDispose(disposedObject);
            }
        }
    }

    public void setDisposalListener(DisposalListener disposalListener) {
        this.disposalListener = disposalListener;
    }
}

