/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator
implements Iterator {
    private Object[] array;
    private int count;
    private int index;

    public ArrayIterator(Object[] array) {
        this.array = array;
        this.index = 0;
        this.count = array != null ? array.length : 0;
    }

    public ArrayIterator(Object[] array, int start, int count) {
        this.array = array;
        this.index = start;
        if (start >= array.length) {
            throw new NoSuchElementException("Invalid ArrayIterator index value");
        }
        this.count = start + count;
        if (this.count > array.length) {
            throw new NoSuchElementException("Invalid ArrayIterator index value");
        }
    }

    @Override
    public boolean hasNext() {
        return this.index < this.count;
    }

    public Object next() {
        if (this.index < this.count) {
            return this.array[this.index++];
        }
        throw new NoSuchElementException("ArrayIterator index value out of bounds");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove operation not supported by ArrayIterator");
    }
}

