/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.openbp.common.util.iterator.ArrayIterator;
import org.openbp.common.util.iterator.EmptyIterator;
import org.openbp.common.util.iterator.SingleIterator;

public class CascadeIterator
implements Iterator {
    public static final int KEY = 0;
    public static final int VALUE = -1;
    private Iterator basis;
    private Iterator actual = EmptyIterator.getInstance();
    private int keyOrValue = -1;
    private boolean hasMore = true;

    protected CascadeIterator init(Object target) {
        return this.init(target, -1);
    }

    protected CascadeIterator init(Object target, int keyOrValue) {
        this.basis = this.getIterator(target, keyOrValue);
        this.keyOrValue = keyOrValue;
        this.stepAhead();
        return this;
    }

    protected CascadeIterator init(Object[] targets) {
        return this.init(targets, -1);
    }

    protected CascadeIterator init(Object[] targets, int keyOrValue) {
        this.keyOrValue = keyOrValue;
        this.basis = new ArrayIterator(targets);
        this.stepAhead();
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.hasMore;
    }

    public Object next() {
        if (!this.hasMore) {
            throw new NoSuchElementException("No more Elements");
        }
        Object result = this.actual.next();
        this.stepAhead();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove operation not supported by CascadeIterator");
    }

    protected void stepAhead() {
        while (!this.actual.hasNext()) {
            if (this.basis.hasNext()) {
                this.actual = this.iterator(this.basis.next(), this.keyOrValue > 0 ? this.keyOrValue - 1 : this.keyOrValue);
                continue;
            }
            this.hasMore = false;
            break;
        }
    }

    protected Iterator getIterator(Object next, int modus) {
        Iterator result = this.getCustomIterator(next, modus);
        if (result != null) {
            return result;
        }
        return new SingleIterator(next);
    }

    protected Iterator getCustomIterator(Object obj, int modus) {
        if (obj instanceof Map) {
            return modus == 0 ? ((Map)obj).keySet().iterator() : ((Map)obj).values().iterator();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).iterator();
        }
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        return null;
    }

    public Iterator iterator(Object obj) {
        return this.iterator(obj, -1);
    }

    public Iterator iterator(Object obj, int modus) {
        if (this.getCustomIterator(obj, modus) == null) {
            return new SingleIterator(obj);
        }
        try {
            return ((CascadeIterator)this.getClass().newInstance()).init(obj, modus);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Iterator iterator(Object[] objs, int modus) {
        if (objs.length == 1) {
            return this.iterator(objs[0], modus);
        }
        try {
            return ((CascadeIterator)this.getClass().newInstance()).init(objs, modus);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        ArrayList<Object> test = new ArrayList<Object>();
        test.add("t1");
        test.add("null");
        ArrayList<String> v = new ArrayList<String>();
        v.add("v1");
        v.add("null");
        v.add("v3");
        v.add("v4");
        test.add(v);
        test.add("t3");
        Iterator en = new CascadeIterator().iterator(test);
        while (en.hasNext()) {
            System.out.println(en.next());
            System.out.println("-----------------------------");
        }
    }
}

