/*
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package org.openbp.common.generic.propertybrowser;


/**
 * Class containing constants for collection types.
 *
 * @author Heiko Erhardt
 */
public final class CollectionTypes
{
	//////////////////////////////////////////////////
	// @@ Type constants
	//////////////////////////////////////////////////

	/**
	 * Array type
	 */
	public static final String ARRAY = "Array";

	/**
	 * Collection type
	 */
	public static final String LIST = "List";

	/**
	 * Vector array type
	 */
	public static final String VECTOR = "Vector";

	/**
	 * Iterator type
	 */
	public static final String ITERATOR = "Iterator";

	/**
	 * Private construction prevents instantiation.
	 */
	private CollectionTypes()
	{
	}
}
