/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.openbp.common.util.iterator.EmptyIterator;
import org.openbp.common.util.iterator.SingleIterator;

public final class CollectionUtil {
    public static final Vector EMPTY_VECTOR = new Vector(0);

    private CollectionUtil() {
    }

    public static boolean containsReference(Collection c, Object object) {
        block4: {
            if (c == null) break block4;
            if (c instanceof ArrayList) {
                ArrayList list = (ArrayList)c;
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Object o = list.get(i);
                    if (o != object) continue;
                    return true;
                }
            } else {
                for (Object o : c) {
                    if (o != object) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void removeReference(Collection c, Object object) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o != object) continue;
                it.remove();
                return;
            }
        }
    }

    public static Iterator iterator(Object o) {
        if (o == null) {
            return EmptyIterator.getInstance();
        }
        if (o instanceof Iterator) {
            return (Iterator)o;
        }
        if (o instanceof Collection) {
            return ((Collection)o).iterator();
        }
        if (o instanceof Map) {
            return ((Map)o).values().iterator();
        }
        if (o.getClass().isArray()) {
            return Arrays.asList((Object[])o).iterator();
        }
        return new SingleIterator(o);
    }

    public static Collection collection(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Collection) {
            return (Collection)o;
        }
        if (o instanceof Iterator) {
            ArrayList list = new ArrayList();
            Iterator it = (Iterator)o;
            while (it.hasNext()) {
                list.add(it.next());
            }
            return list;
        }
        if (o.getClass().isArray()) {
            int l = Array.getLength(o);
            if (l == 0) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < l; ++i) {
                list.add(Array.get(o, i));
            }
            return list;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(o);
        return list;
    }

    public static void addAll(Collection c, Iterator it) {
        if (it != null && c != null) {
            while (it.hasNext()) {
                Object o = it.next();
                c.add(o);
            }
        }
    }

    public static void addAll(Collection c, Enumeration en) {
        if (en != null && c != null) {
            while (en.hasMoreElements()) {
                Object o = en.nextElement();
                c.add(o);
            }
        }
    }

    public static void addAll(Collection c, Object[] array) {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            c.add(array[i]);
        }
    }

    public static ArrayList iteratorToArrayList(Iterator it) {
        if (it != null) {
            ArrayList list = null;
            while (it.hasNext()) {
                if (list == null) {
                    list = new ArrayList();
                }
                Object o = it.next();
                list.add(o);
            }
            return list;
        }
        return null;
    }

    public static Object[] toArray(Collection c, Class cls) {
        if (c == null) {
            return null;
        }
        int n = c.size();
        if (n == 0) {
            return null;
        }
        Object[] result = cls != null ? (Object[])Array.newInstance(cls, n) : new Object[n];
        Iterator it = c.iterator();
        for (int i = 0; i < n; ++i) {
            Object o = it.next();
            if (o != null && cls != null && !cls.isAssignableFrom(o.getClass())) {
                throw new ClassCastException("Cant cast object of the type '" + o.getClass().getName() + "' to '" + cls.getName() + "'");
            }
            result[i] = o;
        }
        return result;
    }

    public static String[] toStringArray(Collection c) {
        if (c == null) {
            return null;
        }
        int n = c.size();
        if (n == 0) {
            return null;
        }
        String[] result = new String[n];
        Iterator it = c.iterator();
        for (int i = 0; i < n; ++i) {
            Object o = it.next();
            result[i] = o != null ? o.toString() : null;
        }
        return result;
    }

    public static void addReverseList(Collection col, List result) {
        int pos = result.size();
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            result.add(pos, iter.next());
        }
    }

    public static void add(List list, int index, Object element) {
        int size = list.size();
        if (index < size) {
            list.add(index, element);
            return;
        }
        for (int i = size; i < index; ++i) {
            list.add(null);
        }
        list.add(element);
    }
}

