/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.application;

import java.io.File;
import org.openbp.common.CommonUtil;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.setting.FixedSettingProvider;
import org.openbp.common.setting.PropertyFileProvider;
import org.openbp.common.setting.SettingResolver;
import org.openbp.common.setting.SettingUtil;
import org.openbp.common.setting.SystemPropertyProvider;
import org.openbp.common.string.StringUtil;

public final class Application {
    public static final String SYSTEM_PROVIDER = "system";
    public static final String ROOTDIR_PROVIDER = "rootdir";
    private static String appName;
    private static String[] arguments;
    private static String rootDir;
    private static boolean dirty;
    private static FixedSettingProvider rootDirProvider;

    private Application() {
    }

    public static void setNameAndArguments(String name, String[] args) {
        appName = name;
        arguments = args;
    }

    public static void initialize() {
        if (!dirty) {
            return;
        }
        Application.initializeRootDir();
        Application.initializeSettingProvidersAndLogger();
        dirty = false;
    }

    protected static void initializeRootDir() {
        if (rootDir == null && arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                if (!arguments[i].equalsIgnoreCase("-rootdir")) continue;
                if (i == arguments.length - 1) {
                    String msg = LogUtil.error(Application.class, "-rootDir option requires an argument");
                    throw new RuntimeException(msg);
                }
                Application.setRootDir(arguments[i + 1]);
                ++i;
            }
        }
        if (rootDir == null) {
            Application.setRootDir(System.getProperty("rootDir"));
        }
        if (rootDir != null) {
            File dir = new File(rootDir);
            if (!dir.isDirectory()) {
                String msg = LogUtil.error(Application.class, "Directory $0 passed as root directory does not seem to exist.", rootDir);
                throw new RuntimeException(msg);
            }
            if (!dir.isAbsolute()) {
                Application.setRootDir(dir.getAbsolutePath());
            }
        }
    }

    protected static void initializeSettingProvidersAndLogger() {
        SettingResolver resolver = SettingUtil.getStandardResolver();
        resolver.clearProvider(SYSTEM_PROVIDER);
        resolver.clearProvider(ROOTDIR_PROVIDER);
        SystemPropertyProvider systemPropertyProvider = SystemPropertyProvider.getInstance();
        resolver.addProvider(SYSTEM_PROVIDER, systemPropertyProvider, 50);
        resolver.addProvider(ROOTDIR_PROVIDER, rootDirProvider, 70);
    }

    public static void registerPropertyResource(String resourceName, int priority, boolean writeable) {
        if (!resourceName.endsWith(".properties")) {
            resourceName = resourceName + ".properties";
        }
        PropertyFileProvider provider = new PropertyFileProvider();
        provider.setPropertyResourceName(resourceName);
        provider.setReadonly(!writeable);
        SettingResolver resolver = SettingUtil.getStandardResolver();
        resolver.addProvider(resourceName, provider, priority);
    }

    public static String getAppName() {
        return appName;
    }

    public static void setAppName(String appNameArg) {
        appName = appNameArg;
    }

    public static String[] getArguments() {
        return arguments;
    }

    public static void setArguments(String[] argumentsArg) {
        arguments = argumentsArg;
    }

    public static String getRootDir() {
        return rootDir;
    }

    public static void setRootDir(String rd) {
        if (!CommonUtil.equalsNull(rd, rootDir)) {
            if (rd != null) {
                rd = StringUtil.normalizePathName(rd);
            }
            rootDir = rd;
            dirty = true;
        }
    }

    public static void defineRootDirSettingName(String name) {
        if (rootDir != null) {
            rootDirProvider.define(name, rootDir);
        }
    }

    static {
        dirty = true;
        rootDirProvider = new FixedSettingProvider();
    }
}

