/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.classloader;

import java.io.File;
import java.net.URL;
import org.openbp.common.classloader.ResourceEntry;
import org.openbp.common.classloader.UrlResourceSpec;
import org.openbp.common.classloader.XClassLoader;
import org.openbp.common.classloader.XClassLoaderUtil;
import org.openbp.common.string.StringUtil;

public class DirectoryUrlResourceSpec
extends UrlResourceSpec {
    public DirectoryUrlResourceSpec() {
    }

    public DirectoryUrlResourceSpec(URL url) {
        super(url);
    }

    @Override
    public void addEntriesToClassLoader(XClassLoader cl) throws Exception {
        File dir = new File(this.getUrl().toURI());
        String basePath = dir.getAbsolutePath();
        this.scanDirectory(cl, dir, basePath);
    }

    private void scanDirectory(XClassLoader cl, File dir, String basePath) throws Exception {
        int basePathLen = basePath.length();
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            File f = new File(dir.getPath(), files[i]);
            if (f.isDirectory()) {
                this.scanDirectory(cl, f, basePath);
                continue;
            }
            String path = f.getAbsolutePath();
            String resourceName = path.substring(basePathLen + 1);
            if (cl.getResourceEntry(resourceName = StringUtil.normalizePathName(resourceName)) != null) continue;
            byte[] content = XClassLoaderUtil.readFileContent(f);
            ResourceEntry entry = new ResourceEntry(f.toURL(), content);
            cl.addResourceEntry(resourceName, entry);
            cl.addResourceEntryForClass(resourceName, entry);
        }
    }
}

