/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.classloader;

import java.util.Enumeration;
import java.util.Hashtable;
import org.openbp.common.classloader.XClassLoaderBase;

public class PackageList {
    private static final Boolean EXACT_MATCH = Boolean.TRUE;
    private static final Boolean WILDCARD_MATCH = Boolean.FALSE;
    private static final String WILDCARD_POSTFIX = "*";
    private Hashtable packages = new Hashtable();

    public void addPackage(String packageName) {
        if (packageName.endsWith(WILDCARD_POSTFIX)) {
            this.packages.put(packageName.substring(0, packageName.length() - WILDCARD_POSTFIX.length() - 1), WILDCARD_MATCH);
        } else {
            this.packages.put(packageName, EXACT_MATCH);
        }
    }

    public void printDebug(String prefix, XClassLoaderBase cl) {
        Enumeration keys = this.packages.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            boolean exactMatch = (Boolean)this.packages.get(key);
            cl.log("Info", prefix + ": " + key + (exactMatch ? "" : ".*"));
        }
    }

    public boolean containsPackage(String packageName) {
        if (packageName == null) {
            return false;
        }
        Enumeration keys = this.packages.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (packageName.equals(key)) {
                return true;
            }
            boolean exactMatch = (Boolean)this.packages.get(key);
            if (exactMatch || !packageName.startsWith(key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsClass(String className) {
        if (className.indexOf(".") == -1) {
            return false;
        }
        return this.containsPackage(className.substring(0, className.lastIndexOf(46)));
    }
}

