/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.classloader;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openbp.common.classloader.ResourceEntry;
import org.openbp.common.classloader.XClassLoader;

public final class XClassLoaderUtil {
    private XClassLoaderUtil() {
    }

    public static byte[] readFileContent(File file) throws Exception {
        int size = (int)file.length();
        byte[] buffer = new byte[size];
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file), 4096);
            for (int pos = 0; pos < size; pos += in.read(buffer, pos, size - pos)) {
            }
        }
        catch (IOException ex) {
            throw new Exception("Error reading file '" + file.getAbsolutePath() + "'.", ex);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanJarStream(XClassLoader cl, InputStream in, URL jarFileUrl) throws Exception {
        ZipInputStream zis = null;
        try {
            ZipEntry ze;
            zis = new ZipInputStream(new BufferedInputStream(in));
            while ((ze = zis.getNextEntry()) != null) {
                int nRead;
                int size;
                String resourceName = ze.getName();
                if (cl.getResourceEntry(resourceName) != null || (size = (int)ze.getSize()) == 0) continue;
                ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
                byte[] buffer = new byte[4096];
                while ((nRead = zis.read(buffer)) > 0) {
                    bos.write(buffer, 0, nRead);
                }
                byte[] content = bos.toByteArray();
                URL jarEntryUrl = XClassLoaderUtil.buildJarEntryUrl(jarFileUrl, resourceName);
                ResourceEntry entry = new ResourceEntry(jarEntryUrl, content);
                cl.addResourceEntry(resourceName, entry);
                XClassLoaderUtil.addResourceEntryForClass(cl, resourceName, entry);
            }
        }
        finally {
            if (zis != null) {
                zis.close();
            }
        }
    }

    private static URL buildJarEntryUrl(URL jarFileUrl, String entryName) throws MalformedURLException {
        StringBuffer result = new StringBuffer("jar:");
        result.append(jarFileUrl);
        result.append("!/");
        result.append(entryName);
        return new URL(result.toString());
    }

    public static void addResourceEntryForClass(XClassLoader cl, String resourceName, ResourceEntry entry) {
        int index = resourceName.indexOf(".class");
        if (index >= 0) {
            String className = resourceName.substring(0, index);
            className = className.replace('/', '.');
            className = className.replace('\\', '.');
            cl.addResourceEntry(className, entry);
        }
    }
}

